package com.arms.egovframework.javaservice.esframework.model.dto.request;

import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SubGroupFieldDTO;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
public class AggregationCardinalityRequestDTO {

	private SubGroupFieldDTO subGroupFieldDTO;

	private String mainField;

	private String mainFieldAlias;

	private boolean isContentView;

	private boolean isAscending;

	private int size = 10000;

	public static SubGroupDTOBuilder builder() {
		return new SubGroupDTOBuilder();
	}

	public static class SubGroupDTOBuilder {
		private String mainField;
		private String mainFieldAlias;
		private boolean isContentView = false;
		private boolean isAscending = false;
		private int size = 10000;
		private SubGroupFieldDTO subGroupFieldDTO;

		public SubGroupDTOBuilder mainField(String mainField) {
			this.mainField = mainField;
			return this;
		}

		public SubGroupDTOBuilder mainFieldAlias(String mainFieldAlias) {
			this.mainFieldAlias = mainFieldAlias;
			return this;
		}

		public SubGroupDTOBuilder isContentView(boolean isContentView) {
			this.isContentView = isContentView;
			return this;
		}

		public SubGroupDTOBuilder isAscending(boolean isAscending) {
			this.isAscending = isAscending;
			return this;
		}

		public SubGroupDTOBuilder size(int size) {
			this.size = size;
			return this;
		}

		public SubGroupDTOBuilder cardinality(SubGroupFieldDTO fields) {
			this.subGroupFieldDTO = fields;
			return this;
		}

		public AggregationCardinalityRequestDTO build() {
			AggregationCardinalityRequestDTO dto = new AggregationCardinalityRequestDTO();
			dto.setMainField(this.mainField);
			dto.setMainFieldAlias(this.mainFieldAlias);
			dto.setContentView(this.isContentView);
			dto.setAscending(this.isAscending);
			dto.setSize(this.size);
			dto.setSubGroupFieldDTO(this.subGroupFieldDTO);
			return dto;
		}
	}
}
