package com.arms.egovframework.javaservice.esframework.esquery.filter;


import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilders;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MatchQueryFilter extends Filter<MatchQueryBuilder> {

	private MatchQueryBuilder matchQueryBuilder;

	public MatchQueryFilter(String name, String value){
		if(name!=null&&value!=null){
			this.matchQueryBuilder = QueryBuilders.matchQuery(name, value);
		}
	}

	public <T> MatchQueryFilter(String name, T value){
		if(name!=null&&value!=null){
			this.matchQueryBuilder = QueryBuilders.matchQuery(name, value);
		}
	}

	public MatchQueryFilter(String name, boolean value){
		if(name!=null){
			this.matchQueryBuilder = QueryBuilders.matchQuery(name, value);
		}
	}
	@Override
	public AbstractQueryBuilder<MatchQueryBuilder> abstractQueryBuilder() {
		return  matchQueryBuilder;
	}

}
