package com.arms.api.util.alm;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Getter
@Setter
@Component
@RefreshScope
@ConfigurationProperties(prefix = "jira.api") // application.yml에 정의된 내용
public class JiraApi {

    private Parameter parameter;
    private Endpoint endpoint;
    private Metadata metadata;
    private int packetSize;

    @Getter
    @Setter
    public static class Parameter {

        private boolean deleteSubtasks;
        private int maxResults;
        private String fields;
        private Jql jql;

        @Getter
        @Setter
        public static class Jql {
            private String updated;
            private String issue;
            private String subtask;
            private String linkedIssue;
            private String manualDate;
        }
    }

    @Getter
    @Setter
    public static class Endpoint {

        private String search;
        private String project;
        private Issue issue;

        @Getter
        @Setter
        public static class Issue {
            private String base;
            private String issuetype;
            private String statuses;
            private String priority;
            private String resolution;
            private String createmeta;
            private Full full;
            private Increment increment;

            @Getter
            @Setter
            public static class Full {
                private String detail;
                private String subtask;
                private String linkedIssue;
            }

            @Getter
            @Setter
            public static class Increment {
                private String detail;
                private String subtask;
                private String linkedIssue;
                private String manualDate;
            }
        }
    }

    @Getter
    @Setter
    public static class Metadata {
        private Fields fields;
    }

    @Getter
    @Setter
    public static class Fields {
        private String project;
        private String issuetype;
        private String summary;
        private String description;
        private String reporter;
        private String priority;
        private String duedate;
    }


    public String 이슈키_대체하기(String 쿼리, String 대체이슈키) {
        return 쿼리.replace("{이슈키}", 대체이슈키);
    }

    public String 프로젝트키_대체하기(String 쿼리, String 대체_프로젝트키) {
        return 쿼리.replace("{프로젝트아이디_또는_키}", 대체_프로젝트키);
    }

    public String 이슈유형키_대체하기(String 쿼리, String 대체_이슈유형키) {
        return 쿼리.replace("{이슈유형아이디_또는_키}", 대체_이슈유형키);
    }

}
