package com.arms.api.util;

import org.jetbrains.annotations.NotNull;

import java.util.*;

public class LRUMap<K,V> extends AbstractMap<K,V> {

    private final LinkedHashMap<K, V> map;

    private final int maxSize;

    public LRUMap(int maxSize){
        this.maxSize = maxSize;

        int initialCapacity = (int) Math.ceil(maxSize / 0.75) + 1;

        this.map = new LinkedHashMap<>(initialCapacity, 0.75f, true){
            @Override
            protected boolean removeEldestEntry(java.util.Map.Entry<K, V> eldest) {
                return size() > LRUMap.this.maxSize;
            }
        };
    }


    @NotNull
    @Override
    public Set<Entry<K, V>> entrySet() {
        return map.entrySet();
    }

    @Override
    public V put(K k,V v) {
        return map.put(k, v);
    }

    @Override
    public V get(Object key) {
        return map.get(key);
    }

}
