package com.arms.api.serverinfo.model.enums;

import lombok.Getter;

@Getter
public enum ServerType {

    CLOUD("클라우드"),
    ON_PREMISS("온프레미스"),
    REDMINE_ON_PREMISS("레드마인_온프레미스");

    private final String type;

    public static ServerType typeValueOf(String name){
        if(name.equals("클라우드")){
            return CLOUD;
        }else if(name.equals("온프레미스")){
            return ON_PREMISS;
        }else if(name.equals("레드마인_온프레미스")){
            return REDMINE_ON_PREMISS;
        }
        throw new IllegalArgumentException("존재 하지 않는 타입입니다");
    }

    ServerType(String type) {
        this.type = type;
    }
}
