package com.arms.api.poc.controller;

import com.arms.api.poc.model.dto.PocDTO;
import com.arms.api.poc.model.entity.PocEntity;
import com.arms.api.poc.model.vo.PocVO;
import com.arms.api.poc.service.PocService;
import com.arms.api.util.response.CommonResponse;
import feign.Param;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/engine/poc")
@Slf4j
@AllArgsConstructor
public class PocController {

    private final PocService pocService;

    @PostMapping
    public ResponseEntity<CommonResponse.ApiResult<String>> savePoc(@RequestBody PocDTO pocDTO) {
        return ResponseEntity.ok(CommonResponse.success(pocService.createPoc(pocDTO)));
    }

    @GetMapping("/{id}")
    public ResponseEntity<CommonResponse.ApiResult<PocEntity>> findPoc(@PathVariable("id") String id) {
        return ResponseEntity.ok(CommonResponse.success(pocService.getPoc(id)));
    }

    @GetMapping
    public ResponseEntity<CommonResponse.ApiResult<PocVO>> pocList(@Param("baseDTO") PocDTO pocDTO) {
        return ResponseEntity.ok(CommonResponse.success(pocService.getPocList(pocDTO)));
    }

    @PutMapping("/{id}")
    public ResponseEntity<CommonResponse.ApiResult<String>> update(
            @PathVariable("id") String id,
            @RequestBody PocDTO pocDTO) {
        return ResponseEntity.ok(CommonResponse.success(pocService.updatePoc(pocDTO)));
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteById(@PathVariable("id") String id) {
        return ResponseEntity.ok(CommonResponse.success(pocService.deletePoc(id)));
    }
}
