package com.arms.api.newsletter.model;

import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import lombok.*;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Builder
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@Document(indexName = "newsletter")
public class NewsletterEntity implements BaseEntity {

    @Id
    @Field(type = FieldType.Keyword, name = "id")
    private String id;

    @Field(type = FieldType.Text, name = "contents")
    private String contents;

    public void updateNewsletterEntity(NewsletterEntity newsletterEntity){

        if (newsletterEntity.contents != null) {
            this.contents = newsletterEntity.contents;
        }

    }

}
