package com.arms.api.issue.type.strategy;

import com.arms.api.issue.type.vo.IssueTypeVO;
import com.arms.api.serverinfo.model.ServerInfo;

import java.util.List;

public class IssueTypeStrategyFactory {

    IssueTypeStrategy issueTypeStrategy;

    public void registerIssueTypeStrategy(IssueTypeStrategy issueTypeStrategy) {
        this.issueTypeStrategy = issueTypeStrategy;
    }

    public List<IssueTypeVO> getIssueTypeList(ServerInfo serverInfo) {
        return this.issueTypeStrategy.getIssueTypeList(serverInfo);
    }

    public List<IssueTypeVO> getIssueTypeListByProject(ServerInfo serverInfo, String projectId) {
        return this.issueTypeStrategy.getIssueTypeListByProject(serverInfo, projectId);
    }

}