package com.arms.api.issue.priority.strategy;

import com.arms.api.issue.priority.model.IssuePriorityDTO;

import com.arms.api.serverinfo.model.ServerInfo;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class IssuePriorityStrategyFactory {

    IssuePriorityStrategy issuePriorityStrategy;

    public void registerIssuePriorityStrategy(IssuePriorityStrategy issuePriorityStrategy) {
        this.issuePriorityStrategy = issuePriorityStrategy;
    }

    public List<IssuePriorityDTO> getIssuePriorityList(ServerInfo serverInfo) {
        return this.issuePriorityStrategy.getIssuePriorityList(serverInfo);
    }

}
