package com.arms.api.issue.priority.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;

import java.util.List;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OnpremiseRedmineIssuePriorityDTO {

    private List<IssuePriority> issue_priorities;

    @Getter
    @Setter
    @Builder
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class IssuePriority {
        private Long id;
        private String name;
        boolean is_default;
        boolean active;
    }
}
