package com.arms.api.issue.almapi.repository;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Repository;

@Repository
@AllArgsConstructor
public class AlmIssueToEntityConverterRepositoryImpl implements AlmIssueToEntityConverterRepository {

    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    @Override
    public AlmIssueEntity findRecentDocByRecentId(String recentId) {
        return esCommonRepositoryWrapper.findRecentDocByRecentId(recentId);
    }

    @Override
    public AlmIssueEntity findRecentHits(SimpleQuery<SearchDocDTO> simpleQuery) {
         return esCommonRepositoryWrapper.findRecentHits(simpleQuery).fetchOnlyOne();
    }


}
