package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.util.StreamUtil;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.*;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
@Slf4j
@EqualsAndHashCode(of = {"issue"})
public class OnPremissJiraIssueVO {

    private Issue issue;

    private ServerInfo serverInfo;

    private AlmIssueWithRequirementDTO almIssueWithRequirementDTO;

    private boolean excludeFromSave;

    private List<Long> linkedIssuePdServiceIds;

    private List<Long> linkedIssuePdServiceVersions;

    public OnPremissJiraIssueVO markAsExcludedFromSave(){
        return OnPremissJiraIssueVO.builder()
                .issue(this.issue)
                .serverInfo(this.serverInfo)
                .almIssueWithRequirementDTO(this.almIssueWithRequirementDTO)
                .excludeFromSave(true)
                .build();
    }

    public OnPremissJiraIssueVO appliedLinkedIssuePdServiceElement(List<AlmIssueWithRequirementDTO> almIssueWithRequirementDTOS){
        return OnPremissJiraIssueVO.builder()
                .issue(this.issue)
                .serverInfo(this.serverInfo)
                .almIssueWithRequirementDTO(
                        almIssueWithRequirementDTOS
                                .stream()
                                .filter(a->a.getIssueKey().equals(issue.getKey()))
                                .findFirst()
                                .orElseGet(()->this.almIssueWithRequirementDTO)
                )
                .linkedIssuePdServiceIds(almIssueWithRequirementDTOS.stream().map(AlmIssueWithRequirementDTO::getServiceId).toList())
                .linkedIssuePdServiceVersions(almIssueWithRequirementDTOS.stream().flatMap(a->a.getVersions().stream()).toList())
                .excludeFromSave(this.excludeFromSave)
                .build();
    }

    public String recentId(){
        return this.serverInfo.getConnectId() +"_"+issue.getProject().getKey()+"_"+issue.getKey();
    }

    public String recentId(String key){
        return this.serverInfo.getConnectId() +"_"+issue.getProject().getKey()+"_"+key;
    }

    public Set<String> relationRecentIds(){

        List<IssueLink> issueRelations = StreamUtil.toStream(issue.getIssueLinks()).toList();

        return issueRelations
                .stream().map(a-> {
                    String projectKey = Arrays.stream(a.getTargetIssueKey().split("-")).findFirst().orElseGet(() -> almIssueWithRequirementDTO.getProjectKeyOrId());
                    return almIssueWithRequirementDTO.extractIssueKeyFromMainKey(projectKey,a.getTargetIssueKey());
                })
                .collect(Collectors.toSet());

    }



}
