package com.arms.api.holidayadmin.model.entity;

import com.arms.api.holidayadmin.model.dto.HolidayDTO;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchTemplateConfig;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.Date;


@Builder
@AllArgsConstructor
@Getter
@Document(indexName = "holiday")
public class HolidayEntity implements BaseEntity {

    @Id
    private String id;

    @Field(type = FieldType.Text, name = "name")
    private String name;

    @Field(type = FieldType.Keyword, name = "holiday")
    private String holiday;

    @Field(type = FieldType.Date, name = "created_date")
    @ElasticSearchCreatedDate
    @Setter
    private Date createdDate;

    @Field(type = FieldType.Date, name = "updated_date")
    @ElasticSearchUpdateDate
    @Setter
    private Date updatedDate;

    public void updateHolidayEntity(HolidayEntity holidayEntity){

        if(holidayEntity.name!=null){
            this.name = holidayEntity.name;
        }

        if(holidayEntity.holiday!=null){
            this.holiday = holidayEntity.holiday;
        }
    }

    private HolidayEntity() {}



}
