package com.arms.api.fluentd.service;

import com.arms.api.fluentd.model.vo.ScheduleHistoryVO;
import com.arms.api.search_engine.dto.BaseSearchAggrDTO;
import com.arms.api.search_engine.dto.SearchDTO;
import com.arms.api.search_engine.vo.SearchAggrResultVO;
import com.arms.api.search_engine.vo.SearchResultVO;
import com.arms.api.fluentd.entity.FluentdEntity;

import java.util.List;

public interface FluentdSearch {

    SearchAggrResultVO aggregateByFluentdLogName(BaseSearchAggrDTO searchAggrDTO);

    SearchResultVO<FluentdEntity> searchFluentdLog(SearchDTO searchDTO);

    void keepAliveConnection();

    List<ScheduleHistoryVO> getScheduleHistory(SearchDTO searchDTO);
}
