package com.arms.api.dashboard.controller;

import com.arms.api.dashboard.model.dto.DashboardDTO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeReqLinkVO;
import com.arms.api.dashboard.model.vo.TopNReqAssigneeVO;
import com.arms.api.dashboard.model.vo.요구사항_지라이슈상태_주별_집계;
import com.arms.api.dashboard.service.Dashboard;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/engine/dashboard")
@Slf4j
@AllArgsConstructor
public class DashboardController {

    private final Dashboard dashboard;

    // 제품별_버전_및_작업자 - 대시보드 Sankey :: 백엔드에서 처리로 API 삭제

    // Dashboard - TreeMap :: 백엔드 처리로 API 삭제

    // 인력별 요구사항 상태 (우하단 오른쪽)
    @PostMapping("/top-req-assignee-links")
    public List<TopNReqAssigneeReqLinkVO> topNAssigneeReqLinks(@RequestBody DashboardDTO dashboardDTO, Integer topN) {

        log.info("[DashboardController :: topNAssigneeReqLinks]");

        return dashboard.topNAssigneeReqLinks(dashboardDTO, topN);
    }


    // 인력별 요구사항 (우하단 왼쪽)
    @PostMapping("/top-req-assignee")
    public List<TopNReqAssigneeVO> topNReqAssignee(@RequestBody DashboardDTO dashboardDTO, Integer topN) {
        log.info("[DashboardController :: topNReqAssignee] :: topN: {}", topN);
        return dashboard.topNReqAssignee(dashboardDTO, topN);
    }


    // 대시보드, 디테일_대시보드 - c3 (좌하단)
    @PostMapping(value = "/aggregate-weekly-req-issue-status", name = "dashboard-c3-v2")
    public ResponseEntity<Map<String, 요구사항_지라이슈상태_주별_집계>> aggregateWeeklyReqIssueStatus( // 주별, 최대 1달
            @RequestBody DashboardDTO dashboardDTO
    ) {
        log.info("[DashboardController :: aggregateWeeklyReqIssueStatus]");

        return ResponseEntity.ok(dashboard.aggregateWeeklyReqIssueStatus(dashboardDTO));
    }

}
