package com.arms.api.clientcase.service;

import com.arms.api.clientcase.model.ClientCaseContentsDTO;
import com.arms.api.clientcase.model.ClientCaseEntity;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@AllArgsConstructor
@Slf4j
public class ClientCaseServiceImpl implements ClientCaseService {

    private final EsCommonRepositoryWrapper<ClientCaseEntity> esCommonRepositoryWrapper;

    @Override
    @Transactional
    public String addClientCase(ClientCaseContentsDTO clientCaseContentsDTO) {

        ClientCaseEntity clientCaseEntity = clientCaseContentsDTO.createClientCaseEntity();

        ClientCaseEntity savedEntity = esCommonRepositoryWrapper.save(clientCaseEntity);

        log.info("ClientCase Contents 저장 완료 - c_id: {}", savedEntity.getC_id());
        return savedEntity.getC_id();
    }

    @Override
    @Transactional
    public String updateClientCase(ClientCaseContentsDTO clientCaseContentsDTO) {

        ClientCaseEntity existingEntity = esCommonRepositoryWrapper.findDocById(clientCaseContentsDTO.getC_id());

        if (existingEntity == null) {
            log.error("ClientCase Contents 업데이트 실패 - ES에 데이터 없음 - c_id: {}", clientCaseContentsDTO.getC_id());
            throw new IllegalStateException("ES에 ClientCase Contents가 존재하지 않습니다 - c_id: " + clientCaseContentsDTO.getC_id());
        }

        existingEntity.setC_clientcase_contents(clientCaseContentsDTO.getC_clientcase_contents());
        existingEntity.setC_clientcase_thumbnail_image(clientCaseContentsDTO.getC_clientcase_thumbnail_image());
        esCommonRepositoryWrapper.save(existingEntity);
        log.info("ClientCase Contents 업데이트 완료 - c_id: {}", existingEntity.getC_id());

        return clientCaseContentsDTO.getC_id();
    }

    @Override
    @Transactional(readOnly = true)
    public ClientCaseContentsDTO getClientCase(String clientCaseId) {

        ClientCaseEntity entity = esCommonRepositoryWrapper.findDocById(clientCaseId);

        if (entity == null) {
            log.error("ClientCase Contents 조회 실패 - ES에 데이터 없음 - c_id: {}", clientCaseId);
            throw new IllegalStateException("ES에 ClientCase Contents가 존재하지 않습니다 - c_id: " + clientCaseId);
        }

        ClientCaseContentsDTO dto = new ClientCaseContentsDTO();
        dto.setC_id(entity.getC_id());
        dto.setC_clientcase_contents(entity.getC_clientcase_contents());
        dto.setC_clientcase_thumbnail_image(entity.getC_clientcase_thumbnail_image());
        log.info("ClientCase Contents 조회 완료 - c_id: {}", clientCaseId);
        return dto;
    }

    @Override
    @Transactional
    public String deleteClientCase(String clientCaseId) {

        ClientCaseEntity existingEntity = esCommonRepositoryWrapper.findDocById(clientCaseId);

        if (existingEntity == null) {
            log.error("ClientCase Contents 삭제 실패 - ES에 데이터 없음 - c_id: {}", clientCaseId);
            throw new IllegalStateException("ES에 ClientCase Contents가 존재하지 않습니다 - c_id: " + clientCaseId);
        }

        esCommonRepositoryWrapper.deleteById(clientCaseId);
        log.info("ClientCase Contents 삭제 완료 - c_id: {}", clientCaseId);

        return clientCaseId;
    }
}
