package com.arms.api.blog.model.entity;

import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.Optional;

@Getter
@Setter
public class BlogDTO extends SearchRequestDTO {

    private Long c_id;
    private String c_blog_thumbnail_url;
    private String c_blog_title;
    private String c_blog_desc;
    private String c_blog_author_id;
    private String c_blog_contents;
    private Date c_blog_created;
    private Date c_blog_updated;
    private Integer c_blog_view_count;

    public BlogEntity createBlogEntity() {
        return BlogEntity.builder()
                .c_id(this.c_id)
                .c_blog_thumbnail_url(this.c_blog_thumbnail_url)
                .c_blog_title(this.c_blog_title)
                .c_blog_desc(this.c_blog_desc)
                .c_blog_author_id(this.c_blog_author_id)
                .c_blog_contents(this.c_blog_contents)
                .c_blog_created(this.c_blog_created)
                .c_blog_updated(this.c_blog_updated)
                .c_blog_view_count(Optional.ofNullable(this.c_blog_view_count).orElse(0))
                .build();
    }

}
