package com.arms.api.bbs.model.dto;

import com.arms.api.bbs.model.constant.BoardType;
import com.arms.api.bbs.model.constant.PostType;
import com.arms.api.bbs.model.entity.BbsEntity;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.ObjectUtils;

@Getter
@Setter
public class BbsDTO extends SearchRequestDTO {

    private String id;

    private String subjectName;

    private String contents;

    private BoardType boardType;

    private PostType postType;

    private String path;

    private String groupId;

    private String userName;

    private String password;

    public BbsDTO toBbsDtoWithBoardTypeAndGroupId(BbsEntity bbsEntity){
        BbsDTO bbsDTO = new BbsDTO();
        bbsDTO.boardType = bbsEntity.getBoardType();
        bbsDTO.groupId = bbsEntity.getGroupId();
        return bbsDTO;
    }

    public BbsEntity toBbsEntityWithUpdate(){
        return createEntity();
    }

    public BbsEntity toBbsEntityWithCreate(){

        BbsEntity bbsEntity = createEntity();

        if (ObjectUtils.isEmpty(this.path)){
            bbsEntity.generateGroupId();
        }

        if (!ObjectUtils.isEmpty(this.path)){
            bbsEntity.generatePath(this.path);
        }

        return bbsEntity;
    }

    private BbsEntity createEntity() {
        return BbsEntity.builder()
                .subjectName(this.subjectName)
                .boardType(this.boardType)
                .postType(this.postType)
                .path(this.path)
                .contents(this.contents)
                .userName(this.userName)
                .password(this.password)
                .build();
    }

}
