package com.arms.api.analysis.topmenu.controller;

import com.arms.api.analysis.topmenu.model.vo.ReqAndIssueTotalCountVO;
import com.arms.api.analysis.topmenu.model.dto.TopMenuDTO;
import com.arms.api.analysis.topmenu.service.AnalysisTopMenu;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/engine/analysis-top-menu")
@Slf4j
@AllArgsConstructor
public class AnalysisTopMenuController {

    private AnalysisTopMenu analysisTopMenu;

    @PostMapping("/totalCountWithReqAndSubtask")
    public ResponseEntity<ReqAndIssueTotalCountVO> topMenuTotalCountWithReqAndSubtask(@RequestBody TopMenuDTO topMenuDTO) {

        log.info("[AnalysisTopMenuController :: topMenuTotalCountWithReqAndSubtask] :: 실행");

        return ResponseEntity.ok(analysisTopMenu.topMenuTotalCountWithReqAndSubtask(topMenuDTO));
    }
}
