package com.arms.api.analysis.resource.model.vo.pie;

import com.arms.api.analysis.resource.model.dto.PieChartDTO;
import lombok.Builder;
import lombok.Getter;

@Getter
@Builder
public class PieChartVO {

    // Name of Assignee for pie-chart
    private String name;
    // IssueCount for pie-chart
    private Long value;
    // ServerId of Assignee used in draw horizontal-bar charts param
    private String serverId;
    // AccountId of Assignee used in draw horizontal-bar charts param
    private String accountId;
    // EmailAddress of Assignee used in draw horizontal-bar charts param
    private String emailAddress;

    public static PieChartVO fromDTO(PieChartDTO dto) {
        return PieChartVO.builder()
                .name(dto.getName())
                .value(dto.getValue())
                .serverId(dto.getServerId())
                .accountId(dto.getAccountId()).emailAddress(dto.getEmailAddress()).build();
    }
}
