package com.arms.api.admin.fluentd.service;


import com.arms.api.admin.esIndex.model.vo.IndexStatusSumVO;
import com.arms.api.fluentd.entity.FluentdEntity;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.egovframework.javaservice.esframework.annotation.IndexStatusSnapShot;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class FluentdIndexAdminServiceImpl implements FluentdIndexAdminService {

    private final EsCommonRepositoryWrapper<FluentdEntity> esCommonRepositoryWrapper;

    @Override
    public void delete() {
        esCommonRepositoryWrapper.deleteIndexWithDayRange(90);
    }

    @Override
    public void delete(int day) {
        esCommonRepositoryWrapper.deleteIndexWithDayRange(day);
    }


    @Override
    @Async
    @IndexStatusSnapShot(value = "fluentd merge index job",clazz = FluentdEntity.class)
    @DwrSendAlarm(messageOnStart = "Fluentd Index Merge 시작", messageOnEnd = "Fluentd Index Merge 완료")
    public void merge() {
        esCommonRepositoryWrapper.mergeWithReindex(7);
    }

    @Override
    @Async
    @IndexStatusSnapShot(value = "fluentd merge index job",clazz = FluentdEntity.class)
    @DwrSendAlarm(messageOnStart = "Fluentd Index Merge 시작", messageOnEnd = "Fluentd Index Merge 완료")
    public void merge(int day) {
        esCommonRepositoryWrapper.mergeWithReindex(day);
    }

    @Override
    public IndexStatusSumVO fluentDIndexSumList() {
        List<CatIndexVO> catIndexVOList = esCommonRepositoryWrapper.catIndexVOList();
        return IndexStatusSumVO.builder()
                .indexName(esCommonRepositoryWrapper.indexAliasName())
                .indexCount(esCommonRepositoryWrapper.indexAllCount())
                .docsCount(catIndexVOList.stream().mapToLong(CatIndexVO::getDocsCount).sum())
                .docDeleted(catIndexVOList.stream().mapToLong(CatIndexVO::getDocDeleted).sum())
                .build();
    }


}
