/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.controller;

import com.arms.api.wiki.dto.CursorMessage;
import com.arms.api.wiki.dto.DocumentState;
import com.arms.api.wiki.dto.JoinPayload;
import com.arms.api.wiki.dto.Position;
import com.arms.api.wiki.dto.SelectionInfo;
import com.arms.api.wiki.dto.UserInfo;
import com.arms.api.wiki.dto.UserInfoDTO;
import com.arms.api.wiki.service.OtService;
import com.arms.api.wiki.service.SessionRegistryService;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;

@Controller
public class EditorController {
    private static final Logger log = LoggerFactory.getLogger(EditorController.class);
    private final SimpMessagingTemplate messagingTemplate;
    private final SessionRegistryService sessionRegistryService;
    private final OtService otService;
    private final StringRedisTemplate stringRedisTemplate;
    private final SetOperations<String, String> setOperations;
    private static final String USER_ACTIVE_DOCS_KEY_PREFIX = "user:active_docs:";
    private static final long USER_TRACKING_EXPIRY_HOURS = 24L;

    @Autowired
    public EditorController(SimpMessagingTemplate messagingTemplate, SessionRegistryService sessionRegistryService, OtService otService, StringRedisTemplate stringRedisTemplate) {
        this.messagingTemplate = messagingTemplate;
        this.sessionRegistryService = sessionRegistryService;
        this.otService = otService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.setOperations = stringRedisTemplate.opsForSet();
    }

    private String getUserTrackingKey(String userId) {
        return USER_ACTIVE_DOCS_KEY_PREFIX + userId;
    }

    @MessageMapping(value={"/join"})
    public void handleJoin(@Payload JoinPayload payload, SimpMessageHeaderAccessor headerAccessor) {
        String sessionId = payload.getSessionId();
        String documentId = payload.getDocumentId();
        String userId = payload.getUserId();
        String userName = payload.getUserName();
        String userColor = payload.getUserColor();
        log.info("Received join request: {}", (Object)payload);
        if (sessionId == null || documentId == null || userId == null || userName == null || userColor == null) {
            log.warn("Invalid join payload received. Missing required fields. Payload: {}", (Object)payload);
            return;
        }
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setId(userId);
        userInfoDTO.setName(userName);
        userInfoDTO.setColor(userColor);
        userInfoDTO.setCursorPosition(null);
        userInfoDTO.setSelection(null);
        try {
            this.sessionRegistryService.userJoined(sessionId, documentId, userInfoDTO);
            log.info("User [{}] registered in session [{}], doc [{}] via /app/join", new Object[]{userId, sessionId, documentId});
            String trackingKey = this.getUserTrackingKey(userId);
            String documentEntry = sessionId + ":" + documentId;
            try {
                this.setOperations.add((Object)trackingKey, (Object[])new String[]{documentEntry});
                this.stringRedisTemplate.expire((Object)trackingKey, 24L, TimeUnit.HOURS);
                log.info("Added entry '{}' to user tracking set '{}' for user [{}]", new Object[]{documentEntry, trackingKey, userId});
            }
            catch (Exception redisEx) {
                log.error("Redis error adding entry '{}' to tracking set '{}' for user [{}]: {}", new Object[]{documentEntry, trackingKey, userId, redisEx.getMessage(), redisEx});
            }
            this.broadcastFullDocumentState(sessionId, documentId, userId);
        }
        catch (Exception e) {
            log.error("Error processing join request for user [{}] in session [{}], doc [{}]: {}", new Object[]{userId, sessionId, documentId, e.getMessage(), e});
        }
    }

    @MessageMapping(value={"/selection"})
    public void handleSelectionUpdate(@Payload CursorMessage message, SimpMessageHeaderAccessor headerAccessor) {
        String sessionId = message.getSessionId();
        String documentId = message.getDocumentId();
        UserInfo senderUserInfo = message.getUserInfo();
        if (sessionId == null || documentId == null || senderUserInfo == null || senderUserInfo.getId() == null) {
            log.warn("Received invalid selection message (missing session, doc, or user info/id): {}", (Object)message);
            return;
        }
        String senderClientId = senderUserInfo.getId();
        try {
            HashMap<String, Integer> cursorPositionMap = null;
            Position cursorPosition = senderUserInfo.getCursorPosition();
            if (cursorPosition != null) {
                cursorPositionMap = new HashMap<String, Integer>();
                cursorPositionMap.put("lineNumber", cursorPosition.getLineNumber());
                cursorPositionMap.put("column", cursorPosition.getColumn());
            }
            SelectionInfo selectionInfo = senderUserInfo.getSelection();
            this.sessionRegistryService.updateUserState(sessionId, documentId, senderClientId, cursorPositionMap, selectionInfo);
            log.debug("[Session: {}] Updated user state for [{}] in doc [{}] via /app/selection", new Object[]{sessionId, senderClientId, documentId});
        }
        catch (Exception e) {
            log.error("[Session: {}] Error persisting selection update for user [{}] in doc [{}]: {}", new Object[]{sessionId, senderClientId, documentId, e.getMessage(), e});
        }
        String selectionDestination = String.format("/topic/sessions/%s/selections/document/%s", sessionId, documentId);
        log.info("Attempting to broadcast selection for session '{}', doc '{}' from client '{}' to {}", new Object[]{sessionId, documentId, senderClientId, selectionDestination});
        try {
            this.messagingTemplate.convertAndSend((Object)selectionDestination, (Object)message);
            log.info("Successfully broadcasted selection update to {} for session '{}', doc '{}'", new Object[]{selectionDestination, sessionId, documentId});
        }
        catch (Exception e) {
            log.error("Error broadcasting selection update to {} for session '{}', doc '{}'", new Object[]{selectionDestination, sessionId, documentId, e});
        }
    }

    private void broadcastFullDocumentState(String sessionId, String documentId, String updatedByClientId) {
        log.info("Broadcasting full document state for session [{}], doc [{}] triggered by user [{}]", new Object[]{sessionId, documentId, updatedByClientId});
        try {
            List<UserInfoDTO> participants = this.sessionRegistryService.getActiveParticipantsForDocument(sessionId, documentId, null);
            String currentContent = this.otService.getDocumentContent(sessionId, documentId);
            int currentRevision = this.otService.getRevision(sessionId, documentId);
            DocumentState fullState = new DocumentState();
            fullState.setSessionId(sessionId);
            fullState.setDocumentId(documentId);
            fullState.setDocument(currentContent);
            fullState.setRevision(currentRevision);
            fullState.setParticipants(participants);
            String stateDestination = String.format("/topic/sessions/%s/state/document/%s", sessionId, documentId);
            this.messagingTemplate.convertAndSend((Object)stateDestination, (Object)fullState);
            log.info("Successfully broadcasted full document state to {} for session [{}], doc [{}]", new Object[]{stateDestination, sessionId, documentId});
        }
        catch (Exception e) {
            log.error("Error broadcasting full document state for session [{}], doc [{}]: {}", new Object[]{sessionId, documentId, e.getMessage(), e});
        }
    }
}

