var SpreadsheetFunctions = (function () {
	let targetId = { "v" : "", "jq" : ""};
	let targetRect = {"width" : 0, "height" : 0};
	let excelData;    // 엑셀 데이터
	let excelColumns;  // 엑셀 컬럼
	let customOptions;// 엑셀 커스텀 옵션들 :: 정의 안할 경우 default
	let isEditingCell = false;


	var setDefaultTargetRect = function () {
		let defaultWidth = $(getTargetId("jq")).width();
		let defaultHeight = $(getTargetId("jq")).height();
		setTargetRect(defaultWidth, defaultHeight);
	};
	var setTargetRect = function(width, height) {
		targetRect.width = width;
		targetRect.height = height;
	};

	var getTargetRect = function (type) {
		if (type === "width") {
			return targetRect.width;
		} else if (type  === "height") {
			return targetRect.height;
		} else {
			return targetRect;
		}
	};

	var setTargetId = function (target) {
		targetId.v = target;
		targetId.jq = "#"+target;
	};

	var getTargetId = function (type) {
		if (type === "jq") {
			return targetId.jq;
		} else {
			return targetId.v;
		}
	};

	var setExcelData = function(data) {
		excelData = data;
	};
	var getExcelData = function () {
		return excelData;
	};
	var setColumns = function(columns) {
		excelColumns = columns;
	};
	var getColumns = function () {
		return excelColumns;
	};

	var setColumnWidth = function (width) {
		if (excelColumns) {
			excelColumns = excelColumns.map(column => ({
				...column, width: (width * column.wRatio) -1
			}));
		}
	};

	function setColumnWidthAsync(width) {
		return new Promise((resolve) => {
			if (excelColumns) {
				excelColumns = excelColumns.map(column => ({
					...column, width: (width * column.wRatio) - 1
				}));
			}
			resolve(); // 컬럼 너비 설정이 완료된 후 resolve 호출
		});
	}

	var setOptions = function(options) {
		customOptions = options;
	};
	var getOptions = function() {
		return customOptions ? customOptions : null;
	};


	var resizeObserver = new ResizeObserver(function(entries) {
		if (isEditingCell) { // 수정중에는 resize 비활성화
			return;
		}
		for (let entry of entries) {
			setTargetRect(entry.contentRect.width, entry.contentRect.height);
			handleResize(entry.target.id, getTargetRect("width"), getTargetRect("height"));
		}
	});

	// 모달요소 크기 변화 관찰(Observer)
	function startObserver() {
		resizeObserver.observe($(getTargetId("jq"))[0]);
	}

	// Observer 멈추기
	function stopObserver() {
		console.log("Stopping ResizeObserver");
		resizeObserver.disconnect();  // 크기 변화를 더 이상 감지하지 않음
	}

	function handleResize(id, width, height) {
		if (id === getTargetId() && height !== 0) {
			if (excelData) {
				drawResizedExcel(getTargetId());
			} else {
				console.log("Spreadsheet.handleResize :: 엑셀 데이터 없음");
			}

		} else {
			console.log("Spreadsheet.handleResize :: id 불일치 또는 height 가 0 입니다.");
		}
	}

	function drawResizedExcel(target) {
		let $targetId = "#"+target;

		if($($targetId).length > 0 && $($targetId)[0].jexcel) {
			$($targetId)[0].jexcel.destroy();
		}

		setColumnWidthAsync(getTargetRect("width") - 50).then(() => {
			$($targetId).spreadsheet($.extend({}, {
				columns: getColumns(),
				data: getExcelData()
			}, getOptions()));

			let jexcel_content_height = getTargetRect("height") - 40 - 30 - 35 - 34;
			$($targetId + " .jexcel_content").css("max-height", jexcel_content_height);
			$($targetId + " .jexcel_content").css("width", "100%");
		});
	}

	function drawExcel(target) {
		let $targetId = "#"+target;

		if($($targetId).length > 0 && $($targetId)[0].jexcel) {
			$($targetId)[0].jexcel.destroy();
		}

		$($targetId).spreadsheet($.extend({}, {
			columns: getColumns(),
			data: getExcelData()
		}, getOptions()));

		let jexcel_content_height = getTargetRect("height") - 40 - 30 - 35 - 34;
		$($targetId + " .jexcel_content").css("max-height", jexcel_content_height);
		$($targetId + " .jexcel_content").css("width", "100%");

	}

	return {
		setTargetId,   getTargetId,
		setTargetRect, getTargetRect, setDefaultTargetRect,
		setExcelData,  getExcelData,
		setColumns,    getColumns,   setColumnWidth,
		setOptions,    getOptions,

		startObserver, stopObserver, drawExcel
	};
})();