////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		[
			"../reference/lightblue4/docs/lib/parsleyjs/dist/parsley.min.js",
			"../reference/lightblue4/docs/lib/parsleyjs/dist/i18n/ko.js"
		]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			$(".widget").widgster();
			$("#sidebar").hide();
			$(".wrap").css("margin-left", 0);
			$("#footer").load("/cover/html/template/landing-footer.html");

			var urlParams = new URL(location.href).searchParams;
			var id = urlParams.get("id");
			var editor;
			var waitCKEDITOR = setInterval(function () {
				try {
					if (window.CKEDITOR) {
						if (window.CKEDITOR.status === "loaded") {
							editor = CKEDITOR.replace("editor", { contentsCss: "./css/ckeditor.css" });
							clearInterval(waitCKEDITOR);
						}
					}
				} catch (err) {
					console.log("CKEDITOR 로드가 완료되지 않아서 초기화 재시도 중...");
				}
			}, 313 /*milli*/);

			var addBoard = function (_post) {
				$.ajax({
					url: "/bbs/post-message",
					type: "POST",
					contentType: "application/json;charset=utf-8",
					data: JSON.stringify(_post),
					success: function (result) {
						location.replace("/cover/template.html?page=boardDetail&id=" + result.response);
					}
				});
			};

			var updateBoard = function (_post) {
				$.ajax({
					url: "/bbs/update-id/" + id,
					type: "PUT",
					contentType: "application/json;charset=utf-8",
					data: JSON.stringify(_post),
					success: function () {
						location.replace("/cover/template.html?page=boardDetail&id=" + id);
					}
				});
			};

			$("#post_form").on("submit", function (event) {
				$.ajax({
					url: "/bbs/verify/captcha",
					type: "POST",
					contentType: "application/json;charset=utf-8",
					data: JSON.stringify({ captcha: $("#input_captcha").val() }),
					success: function () {
						var post = Object.fromEntries(new FormData(event.target));
						post.contents = editor.getData();
						post.boardType = "LANDING";

						if (!isEmpty(id)) {
							updateBoard(post);
						} else {
							addBoard(post);
						}
					},
					error: function (xhr) {
						jError("캡차 인증에 실패했습니다. 다시 시도해주세요.: " + (xhr.responseJSON?.error || "알 수 없는 오류"));
					}
				});

				return false;
			});

			$("#btn_refresh_captcha").on("click", function () {
				$("#captcha").attr("src", "/bbs/verify/image?_t=" + new Date().getTime());
			});

			(function () {
				if (isEmpty(id)) return;

				var $postForm = $("#post_form");

				$postForm.find("button[type='submit']").removeClass("btn-primary").addClass("btn-success").text("게시글 수정");

				$.ajax({
					url: "/bbs/find-path/find-id/" + id,
					type: "GET",
					data: { postType: "POST" },
					success: function (data) {
						var post = data.response[0];

						new FormData($postForm[0]).forEach(function (_, _key) {
							$postForm.find("[name='" + _key + "']").val(post[_key]);
						});

						$("#editor").html(post.contents);
					}
				});
			})();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}
