package com.arms.api.kafka.reqadd.controller;


import com.arms.api.kafka.reqadd.model.ReqAddDTO;
import com.arms.api.kafka.reqadd.model.ReqAddResponseVO;
import com.arms.api.kafka.reqadd.service.ReqAddService;
import com.arms.api.util.response.CommonResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Mono;


import java.util.Collections;
import java.util.List;

import static com.arms.api.util.response.CommonResponse.success;

@Slf4j
@RestController
@RequestMapping("/auth-user/message/queue")
public class UserReqAddController {

    @Autowired(required = false)
    private ReqAddService reqAddService;

    @GetMapping("/requirements")
    public Mono<CommonResponse.ApiResult<List<ReqAddResponseVO>>> read() {

        if (reqAddService != null) {

            List<ReqAddResponseVO> response = reqAddService.read();

            return Mono.just(success(response));

        }

        return Mono.just(success(Collections.emptyList()));
    }

    @PostMapping("/requirements/{changeReqTableName}")
    public Mono<CommonResponse.ApiResult<String>> create(
            @PathVariable String changeReqTableName,
            @RequestBody ReqAddDTO payload
    ) {

        if (reqAddService != null) {

            reqAddService.create(changeReqTableName, payload);

        }

        return Mono.just(success("OK"));

    }


/*
========================================================================
HTTP Method  | 메서드명               | 용도
========================================================================
POST         | create                 | 새 리소스 생성
------------------------------------------------------------------------
PUT          | update 또는 replace    | 전체 리소스 수정/교체
------------------------------------------------------------------------
PATCH        | update 또는 modify     | 부분 리소스 수정
------------------------------------------------------------------------
GET          | read 또는 get          | 리소스 조회
------------------------------------------------------------------------
DELETE       | delete 또는 remove     | 리소스 삭제
========================================================================
 */

    @PutMapping("/requirements/{changeReqTableName}") // HTTP POST 메서드를 동적 경로에 매핑
    public Mono<CommonResponse.ApiResult<String>> update(
            @PathVariable String changeReqTableName, // URL 경로 변수를 메서드 파라미터로 바인딩
            @RequestBody String payload // HTTP 요청 본문을 String으로 바인딩
    ) {

        // reqService가 null이 아닌지 확인
        if (reqAddService != null) {

            // 서비스 레이어를 통해 요구사항 생성
            // changeReqTableName: 대상 테이블 이름
            // payload: 생성할 요구사항 데이터 (JSON 문자열)
            reqAddService.update(changeReqTableName, payload);

        }

        // 생성 완료 후 "OK" 메시지를 성공 응답으로 반환
        // 실제 생성된 데이터나 상세 정보는 반환하지 않고 단순 성공 표시만 함
        return Mono.just(success("OK"));

    }

    @DeleteMapping("/requirements/{changeReqTableName}") // HTTP POST 메서드를 동적 경로에 매핑
    public Mono<CommonResponse.ApiResult<String>> delete(
            @PathVariable String changeReqTableName, // URL 경로 변수를 메서드 파라미터로 바인딩
            @RequestBody String payload // HTTP 요청 본문을 String으로 바인딩
    ) {

        // reqService가 null이 아닌지 확인
        if (reqAddService != null) {

            // 서비스 레이어를 통해 요구사항 생성
            // changeReqTableName: 대상 테이블 이름
            // payload: 생성할 요구사항 데이터 (JSON 문자열)
            reqAddService.delete(changeReqTableName, payload);

        }

        // 생성 완료 후 "OK" 메시지를 성공 응답으로 반환
        // 실제 생성된 데이터나 상세 정보는 반환하지 않고 단순 성공 표시만 함
        return Mono.just(success("OK"));

    }

}