package com.arms.egovframework.javaservice.gcframework.parser;

import com.arms.egovframework.javaservice.gcframework.model.AbstractContentVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

import java.io.IOException;

public class YamlContentParser extends AbstractContentParser<AbstractContentVO> {

    private final ObjectMapper yamlMapper = new ObjectMapper(new YAMLFactory());

    @Override
    public String getHandledType() {
        return "yaml";
    }

    @Override
    protected AbstractContentVO doParse(String decodedContent, Class<AbstractContentVO> targetVoType) {
        try {
            return yamlMapper.readValue(decodedContent, targetVoType);
        } catch (IOException e) {
            throw new RuntimeException("Failed to parse YAML content", e);
        }
    }

    @Override
    protected String doSerialize(AbstractContentVO abstractContentVO) {
        try {
            return yamlMapper.writeValueAsString(abstractContentVO);
        } catch (IOException e) {
            throw new RuntimeException("Failed to serialize to YAML content", e);
        }
    }
}
