package com.arms.egovframework.javaservice.gcframework.parser;

import com.arms.egovframework.javaservice.gcframework.model.AbstractContentVO;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

public class JsonContentParser extends AbstractContentParser<AbstractContentVO> {

    private final ObjectMapper jsonMapper = new ObjectMapper();

    @Override
    public String getHandledType() {
        return "json";
    }

    @Override
    protected AbstractContentVO doParse(String decodedContent, Class<AbstractContentVO> targetVoType) {
        try {
            return jsonMapper.readValue(decodedContent, targetVoType);
        } catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON content", e);
        }
    }

    @Override
    protected String doSerialize(AbstractContentVO targetVO) {
        try {
            return jsonMapper.writeValueAsString(targetVO);
        } catch (IOException e) {
            throw new RuntimeException("Failed to serialize to JSON content", e);
        }
    }
}
