/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.egovframework.javaservice.esframework.annotation.IndexStatusSnapShot;
import com.arms.egovframework.javaservice.esframework.model.entity.IndexStatusEntity;
import com.arms.egovframework.javaservice.esframework.model.entity.JobStatus;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepository;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.FindRepository;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class IndexStatusSaveAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexStatusSaveAspect.class);
    private final EsCommonRepositoryWrapper<IndexStatusEntity> esCommonRepositoryWrapper;
    private final FindRepository findRepository;

    @Around(value="@annotation(indexStatusSnapShot)")
    public Object indexStatusAspect(ProceedingJoinPoint joinPoint, IndexStatusSnapShot indexStatusSnapShot) throws Throwable {
        Object target = joinPoint.getTarget();
        EsCommonRepository<Object, Serializable> repositoryByClass = this.findRepository.findRepositoryByClass(indexStatusSnapShot.clazz());
        String uuid = String.valueOf(UUID.randomUUID());
        log.info("BEFORE :: {}", (Object)indexStatusSnapShot.value());
        this.saveIndexStatus(repositoryByClass.indexAliasName(), this.getCatIndexVOList(repositoryByClass), uuid, JobStatus.BEFORE);
        Object joinPointResult = joinPoint.proceed();
        log.info("AFTER :: {}", (Object)indexStatusSnapShot.value());
        this.saveIndexStatus(repositoryByClass.indexAliasName(), this.getCatIndexVOList(repositoryByClass), uuid, JobStatus.AFTER);
        return joinPointResult;
    }

    private List<CatIndexVO> getCatIndexVOList(EsCommonRepository<Object, Serializable> repositoryByClass) {
        List<CatIndexVO> catIndexVOS = repositoryByClass.catIndexVOList();
        return new ArrayList<CatIndexVO>(catIndexVOS);
    }

    private void saveIndexStatus(String indexAlias, List<CatIndexVO> catIndexVOList, String jobId, JobStatus jobStatus) {
        if (jobId == null) {
            throw new IllegalArgumentException("jobId is null");
        }
        for (CatIndexVO catIndexVO : catIndexVOList) {
            IndexStatusEntity indexStatusEntity = catIndexVO.toEntity();
            indexStatusEntity.setIndexAlias(indexAlias);
            indexStatusEntity.setJobId(jobId);
            indexStatusEntity.setJobStatus(jobStatus);
            this.esCommonRepositoryWrapper.save(indexStatusEntity);
        }
    }

    @Generated
    public IndexStatusSaveAspect(EsCommonRepositoryWrapper<IndexStatusEntity> esCommonRepositoryWrapper, FindRepository findRepository) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.findRepository = findRepository;
    }
}

