/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.config;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchTemplateConfig;
import com.arms.egovframework.javaservice.esframework.annotation.RollingIndexName;
import com.arms.egovframework.javaservice.esframework.util.ReflectionUtil;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActionParameters;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class EsIndexTemplateConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsIndexTemplateConfig.class);
    private final ElasticsearchOperations operations;
    private final RestHighLevelClient restHighLevelClient;
    public final String elasticsearchRepositoryPath;

    public EsIndexTemplateConfig(ElasticsearchOperations operations, RestHighLevelClient restHighLevelClient, @Value(value="${spring.elasticsearch-repository.path}") String elasticsearchRepositoryPath) {
        this.operations = operations;
        this.restHighLevelClient = restHighLevelClient;
        this.elasticsearchRepositoryPath = elasticsearchRepositoryPath;
    }

    @PostConstruct
    public void run() {
        Set<String> annotatedClasses = ReflectionUtil.findAnnotatedClasses(ElasticSearchTemplateConfig.class, this.elasticsearchRepositoryPath);
        annotatedClasses.stream().map(clazz -> {
            try {
                return Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }).forEach(clazz -> {
            org.springframework.data.elasticsearch.annotations.Document document = (org.springframework.data.elasticsearch.annotations.Document)AnnotationUtils.findAnnotation((Class)clazz, org.springframework.data.elasticsearch.annotations.Document.class);
            if (document != null) {
                IndexCoordinates indexCoordinatesFor = this.operations.getIndexCoordinatesFor(clazz);
                String indexName = indexCoordinatesFor.getIndexName();
                IndexOperations indexOperations = this.operations.indexOps(clazz);
                this.createTemplate(indexName, indexOperations, (Class<?>)clazz);
                this.createIndex(indexName, (Class<?>)clazz);
                this.createAlias(indexName, indexOperations);
            }
        });
    }

    private boolean isExistRollingIndexNameAnnotation(Class<?> clazz) {
        try {
            ReflectionUtil.methodInfo(clazz, RollingIndexName.class);
            return true;
        }
        catch (RuntimeException e) {
            log.info("RollingIndexName \uc5b4\ub178\ud14c\uc774\uc158\uc774 \uc5c6\uc74c : {}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void createTemplate(String indexName, IndexOperations indexOperations, Class<?> clazz) {
        String templateName = indexName + "-template";
        String templatePattern = indexName + "*";
        if (this.isExistRollingIndexNameAnnotation(clazz)) {
            templatePattern = indexName + "-*";
        }
        if (!indexOperations.existsTemplate(templateName)) {
            log.info("template-{} \uc0dd\uc131\uc9c4\ud589", (Object)templateName);
            Document mapping = indexOperations.createMapping();
            PutTemplateRequest.TemplateRequestBuilder templateRequestBuilder = PutTemplateRequest.builder((String)templateName, (String[])new String[]{templatePattern}).withMappings(mapping);
            if (this.isExistRollingIndexNameAnnotation(clazz)) {
                templateRequestBuilder.withAliasActions(new AliasActions(new AliasAction[0]).add(new AliasAction[]{new AliasAction.Add(AliasActionParameters.builderForTemplate().withAliases(indexOperations.getIndexCoordinates().getIndexNames()).build())}));
            }
            PutTemplateRequest request = templateRequestBuilder.build();
            try {
                indexOperations.putTemplate(request);
            }
            catch (RuntimeException e) {
                log.info("\ud15c\ud50c\ub808\uc774\ud2b8 \uc0dd\uc131 \ud328\uc2a4 : {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createIndex(String indexName, Class<?> clazz) {
        try {
            Method method = ReflectionUtil.methodInfo(clazz, RollingIndexName.class);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object o = constructor.newInstance(new Object[0]);
            if (this.isExistRollingIndexNameAnnotation(clazz)) {
                indexName = (String)indexName + "-" + String.valueOf(method.invoke(o, new Object[0]));
            }
            GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{indexName});
            boolean exists = this.restHighLevelClient.indices().exists(getIndexRequest, RequestOptions.DEFAULT);
            if (!exists) {
                CreateIndexRequest createIndexRequest = new CreateIndexRequest((String)indexName);
                this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
            }
        }
        catch (RuntimeException e) {
            log.info("\uc778\ub371\uc2a4 \uc0dd\uc131 \ud328\uc2a4 : {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createAlias(String indexName, IndexOperations indexOperations) {
        try {
            GetIndexResponse getIndexResponse = this.restHighLevelClient.indices().get(new GetIndexRequest(new String[]{indexName + "*"}), RequestOptions.DEFAULT);
            Map aliasesMap = getIndexResponse.getAliases();
            Object[] isEmptyAliasIndex = (String[])aliasesMap.entrySet().stream().filter(a -> ((List)a.getValue()).isEmpty()).map(Map.Entry::getKey).toArray(String[]::new);
            if (!ObjectUtils.isEmpty((Object[])isEmptyAliasIndex)) {
                AliasActions add = new AliasActions(new AliasAction[0]).add(new AliasAction[]{new AliasAction.Add(AliasActionParameters.builderForTemplate().withAliases(indexOperations.getIndexCoordinates().getIndexNames()).withIndices((String[])isEmptyAliasIndex).build())});
                indexOperations.alias(add);
            }
        }
        catch (RuntimeException e) {
            log.info("\uc54c\ub9ac\uc544\uc2a4 \uc0dd\uc131 \ud328\uc2a4 : {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

