/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import com.arms.config.ElasticsearchProperties;
import com.arms.egovframework.javaservice.esframework.custom.client.CustomOpenSearchRestTemplate;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryImpl;
import jakarta.annotation.PreDestroy;
import lombok.Generated;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.data.client.orhlc.AbstractOpenSearchConfiguration;
import org.opensearch.data.client.orhlc.ClientConfiguration;
import org.opensearch.data.client.orhlc.RestClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(basePackages={"com.arms"}, repositoryBaseClass=EsCommonRepositoryImpl.class)
@ComponentScan(basePackages={"com.arms"})
public class OpensearchClientConfig
extends AbstractOpenSearchConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpensearchClientConfig.class);
    private final ElasticsearchProperties properties;
    private RestHighLevelClient client;

    public OpensearchClientConfig(ElasticsearchProperties properties) {
        this.properties = properties;
    }

    public RestHighLevelClient opensearchClient() {
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().connectedTo(this.properties.getUrl()).withClientConfigurer((ClientConfiguration.ClientConfigurationCallback)RestClients.RestClientConfigurationCallback.from(httpAsyncClientBuilder -> {
            httpAsyncClientBuilder.setKeepAliveStrategy(this.connectionKeepAliveStrategy());
            return httpAsyncClientBuilder;
        })).withConnectTimeout(60000L).withSocketTimeout(60000L).build();
        this.client = RestClients.create((ClientConfiguration)clientConfiguration).rest();
        return this.client;
    }

    @PreDestroy
    public void closeClient() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            log.error("Error closing Elasticsearch client: ", (Throwable)e);
        }
    }

    protected RefreshPolicy refreshPolicy() {
        return RefreshPolicy.IMMEDIATE;
    }

    @Bean(name={"keepAliveStrategy"})
    public ConnectionKeepAliveStrategy connectionKeepAliveStrategy() {
        return (response, context) -> 180000L;
    }

    @Bean(name={"elasticsearchOperations", "elasticsearchTemplate", "opensearchTemplate"})
    public ElasticsearchOperations elasticsearchOperations(ElasticsearchConverter elasticsearchConverter, RestHighLevelClient opensearchClient) {
        CustomOpenSearchRestTemplate template = new CustomOpenSearchRestTemplate(opensearchClient, elasticsearchConverter);
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }
}

