/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.controller;

import com.arms.api.util.response.CommonResponse;
import com.arms.api.wiki.model.WikiDTO;
import com.arms.api.wiki.model.WikiVO;
import com.arms.api.wiki.model.WikiVersionsVO;
import com.arms.api.wiki.service.WikiService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/wiki"})
public class WikiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WikiController.class);
    private final WikiService wikiService;

    @GetMapping(value={"/{wikiId}"})
    public ResponseEntity<CommonResponse.ApiResult<WikiVO>> getWiki(@PathVariable(value="wikiId") String wikiId) {
        log.info("[ WikiController :: getWiki ] wikiId => {}", (Object)wikiId);
        return ResponseEntity.ok(CommonResponse.success(this.wikiService.getWiki(wikiId)));
    }

    @GetMapping(value={"/{wikiId}/{version}"})
    public ResponseEntity<CommonResponse.ApiResult<WikiVO>> getWiki(@PathVariable(value="wikiId") String wikiId, @PathVariable(value="version") Long version) {
        log.info("[ WikiController :: getWiki ] wikiId => {}, version => {}", (Object)wikiId, (Object)version);
        return ResponseEntity.ok(CommonResponse.success(this.wikiService.getWiki(wikiId, version)));
    }

    @GetMapping(value={"/version/{wikiId}"})
    public ResponseEntity<CommonResponse.ApiResult<WikiVersionsVO>> getWikiVersion(@PathVariable(value="wikiId") String wikiId, @RequestParam(value="size") int size, @RequestParam(value="page") int page) {
        log.info("[ WikiController :: getWikiVersion ] wikiId => {}", (Object)wikiId);
        return ResponseEntity.ok(CommonResponse.success(this.wikiService.getWikiVersions(wikiId, size, page)));
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<String> createWiki(@RequestBody WikiDTO wikiDTO) {
        log.info("[ WikiController :: createWiki ] id => {}", (Object)wikiDTO.getId());
        return ResponseEntity.ok((Object)this.wikiService.createWiki(wikiDTO));
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<String> updateWiki(@RequestBody WikiDTO wikiDTO) {
        log.info("[ WikiController :: updateWiki ] id => {}", (Object)wikiDTO.getId());
        return ResponseEntity.ok((Object)this.wikiService.updateWiki(wikiDTO));
    }

    @PutMapping(value={"/change-recent"})
    public ResponseEntity<CommonResponse.ApiResult<String>> changeRecent(@RequestBody WikiDTO wikiDTO) {
        log.info("[ WikiController :: changeRecent ] id => {}", (Object)wikiDTO.getId());
        this.wikiService.changeRecent(wikiDTO);
        return ResponseEntity.ok(CommonResponse.success(wikiDTO.getId()));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteWiki(@PathVariable(value="id") String deleteId) {
        log.info("[ WikiController :: deleteWiki ] id => {}", (Object)deleteId);
        return ResponseEntity.ok(CommonResponse.success(this.wikiService.deleteWiki(deleteId)));
    }

    @Generated
    public WikiController(WikiService wikiService) {
        this.wikiService = wikiService;
    }
}

