/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.type.controller;

import com.arms.api.issue.type.service.IssueTypeService;
import com.arms.api.issue.type.vo.IssueTypeVO;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{connectId}/jira/issuetype"})
public class IssueTypeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueTypeController.class);
    private final IssueTypeService issueTypeService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public List<IssueTypeVO> getIssueTypeList(@PathVariable(value="connectId") String connectId) {
        if (connectId == null) {
            log.error("getIssueTypeList Error: connectId {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getIssueTypeList Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        return this.issueTypeService.getIssueTypeList(connectId);
    }

    @ResponseBody
    @RequestMapping(value={"/project/{projectId}"}, method={RequestMethod.GET})
    public List<IssueTypeVO> getIssueTypeListByProject(@PathVariable(value="connectId") String connectId, @PathVariable(value="projectId") String projectId) {
        if (connectId == null) {
            log.error("getIssueTypeListByProject Error: connectId {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getIssueTypeListByProject Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            log.error("getIssueTypeListByProject Error projectId {}", (Object)ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getIssueTypeListByProject Error projectId " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
        }
        return this.issueTypeService.getIssueTypeListByProject(connectId, projectId);
    }

    @Generated
    public IssueTypeController(IssueTypeService issueTypeService) {
        this.issueTypeService = issueTypeService;
    }
}

