/*
 * Decompiled with CFR 0.152.
 */
package com.arms.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSerializer.class);
    private static final ObjectMapper objectMapper = DataSerializer.initialize();

    private static ObjectMapper initialize() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static <T> T deserialize(String data, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(data, clazz);
        }
        catch (JsonProcessingException e) {
            log.error("[DataSerializer.deserialize] data={}, clazz={}", new Object[]{data, clazz, e});
            return null;
        }
    }

    public static <T> T deserialize(Object data, Class<T> clazz) {
        return (T)objectMapper.convertValue(data, clazz);
    }

    public static String serialize(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("[DataSerializer.serialize] object={}", object, (Object)e);
            return null;
        }
    }

    @Generated
    private DataSerializer() {
    }
}

