////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
    var pluginGroups = [
        ["./css/poc/poc-container.css"],
        ["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"]
    ];

    loadPluginGroupsParallelAndSequential(pluginGroups)
        .then(function () {
            console.log("모든 플러그인 로드 완료");

            $(".widget").widgster();
            $("#sidebar").hide();
            $(".wrap").css("margin-left", 0);
            $("#footer").load("/cover/html/template/landing-footer.html");

            initializePOCForm();
            initializeFormInteractions();
            // initializeCosmosBackground();
        })
        .catch(function (error) {
            console.error("플러그인 로드 중 오류 발생");
            console.error(error);
        });
}

function initializePOCForm() {

    checkAdminPermission();

    $('#poc-form').find('input[required], textarea[required], select[required]').on('blur', function() {
        validateField($(this));
    });

    $('#poc-form').find('select[required]').on('change', function() {
        removeFieldError($(this));
    });

    $('#poc-form').find('input, textarea').on('input', function() {
        removeFieldError($(this));
    });
    
    $('#poc-form').on('submit', function(e) {
        e.preventDefault();
        
        var isValid = true;
        $(this).find('input[required], select[required], textarea[required]').each(function() {
            if (!validateField($(this))) {
                isValid = false;
            }
        });
        
        if (!isValid) {
            return;
        }
        // 체크박스 처리를 위해 먼저 값 설정
        var $checkbox = $(this).find('input[name="c_poc_marketing_consent"]');
        if (!$checkbox.is(':checked')) {
            $checkbox.val('false');
        } else {
            $checkbox.val('true');
        }

        var formData = $(this).serialize();

        var $submitBtn = $(this).find('button[type="submit"]');
        var originalText = $submitBtn.text();
        $submitBtn.prop('disabled', true).html(
            originalText + '<span class="loading-dots"><span></span><span></span><span></span></span>'
        );

        $.ajax({
            url: '/auth-anon/api/arms/poc/addPoc.do',
            type: 'POST',
            data: formData,
            statusCode: {
                200: function() {
                    $submitBtn.prop('disabled', false).text(originalText);
                    $('#poc-form')[0].reset();

                    window.location.href = '/cover/template.html?page=pocThankyou';
                }
            }
        });
    });
}

function validateField($field) {
    var value = $field.val();
    var isValid = true;

    if (!value || value.trim() === '') {
        showFieldError($field, '필수 입력 항목입니다.');
        isValid = false;
    } 
    else if ($field.attr('type') === 'email') {
        var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailPattern.test(value)) {
            showFieldError($field, '유효한 이메일 주소를 입력해주세요.');
            isValid = false;
        }
    }
    else if ($field.attr('type') === 'tel') {
        var phonePattern = /^[0-9-+() ]+$/;
        if (!phonePattern.test(value)) {
            showFieldError($field, '유효한 전화번호를 입력해주세요.');
            isValid = false;
        }
    }
    
    return isValid;
}

function showFieldError($field, message) {
    removeFieldError($field);

    var $error = $('<div class="field-error-message">' + message + '</div>');
    $field.after($error);
}

function removeFieldError($field) {
    var $formGroup = $field.closest('.form-group');
    $formGroup.find('.field-error-message').remove();
}

function initializeFormInteractions() {
    $('.process-step').hover(
        function() {
            $(this).css('transform', 'translateX(5px)');
        },
        function() {
            $(this).css('transform', 'translateX(0)');
        }
    );

    $('#admin-button').on('click', function() {
        window.location.href = '/cover/template.html?page=pocAdmin';
    });
}

function checkAdminPermission() {
    $.ajax({
        url: "/auth-user/me",
        type: "GET",
        timeout: 7313,
        global: false,
        statusCode: {
            200: function (json) {
                console.log("[ POC :: authUserCheck ] userName = " + json.preferred_username);
                console.log("[ POC :: authUserCheck ] roles = " + json.realm_access.roles);

                var permissions = json.realm_access.roles;

                if (permissions && permissions.indexOf("ROLE_ADMIN") != -1) {
                    document.getElementById("admin-button").classList.remove("hidden");
                }
            }
        }
    });
}

// function initializeCosmosBackground() {
//     Promise.all([
//         import('three'),
//         import('three/addons/controls/OrbitControls.js')
//     ]).then(([THREE, { OrbitControls }]) => {
//         const container = document.getElementById('cosmos-container');
//         const canvas = document.getElementById('cosmos-canvas');

//         if (!container || !canvas) return;

//         const scene = new THREE.Scene();
//         const camera = new THREE.PerspectiveCamera(
//             60,
//             container.clientWidth / container.clientHeight,
//             0.1,
//             2000
//         );
//         camera.position.z = 350;

//         const renderer = new THREE.WebGLRenderer({
//             canvas: canvas,
//             alpha: true,
//             antialias: true
//         });
//         renderer.setSize(container.clientWidth, container.clientHeight);
//         renderer.setPixelRatio(window.devicePixelRatio);

//         const controls = new OrbitControls(camera, renderer.domElement);
//         controls.enableDamping = true;
//         controls.dampingFactor = 0.05;
//         controls.autoRotate = true;
//         controls.autoRotateSpeed = 0.5;
//         controls.enableZoom = false;
//         controls.enablePan = false;

//         const starCount = 5000;
//         const geometry = new THREE.BufferGeometry();
//         const positions = new Float32Array(starCount * 3);
//         const colors = new Float32Array(starCount * 3);

//         for (let i = 0; i < starCount; i++) {
//             const radius = Math.random() * 100 + 60;
//             const theta = Math.random() * Math.PI * 2;
//             const phi = Math.acos(Math.random() * 2 - 1);

//             positions[i * 3] = radius * Math.sin(phi) * Math.cos(theta);
//             positions[i * 3 + 1] = radius * Math.sin(phi) * Math.sin(theta);
//             positions[i * 3 + 2] = radius * Math.cos(phi);

//             const temp = Math.random();
//             colors[i * 3] = 0.8 + temp * 0.2;
//             colors[i * 3 + 1] = 0.9 + temp * 0.1;
//             colors[i * 3 + 2] = 1.0;
//         }

//         geometry.setAttribute('position', new THREE.BufferAttribute(positions, 3));
//         geometry.setAttribute('color', new THREE.BufferAttribute(colors, 3));

//         const material = new THREE.PointsMaterial({
//             size: 2,
//             vertexColors: true,
//             transparent: true,
//             opacity: 0.8,
//             sizeAttenuation: true
//         });

//         const stars = new THREE.Points(geometry, material);
//         scene.add(stars);

//         function animate() {
//             requestAnimationFrame(animate);
//             controls.update();
//             renderer.render(scene, camera);
//         }

//         animate();

//         window.addEventListener('resize', () => {
//             if (!container) return;
//             camera.aspect = container.clientWidth / container.clientHeight;
//             camera.updateProjectionMatrix();
//             renderer.setSize(container.clientWidth, container.clientHeight);
//         });
//     }).catch((error) => {
//         console.error('Three.js 로드 실패:', error);
//     });
// }