////////////////////////////////////////////////////////////////////////////////////////
// A-RMS Patch Note Page JavaScript - FF14 Pure Style with Infinite Scroll
////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////
// Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		["../reference/light-blue/lib/vendor/jquery.ui.widget.js", "../reference/lightblue4/docs/lib/widgster/widgster.js"],
		["../reference/lightblue4/docs/lib/bootstrap-select/dist/js/bootstrap-select.min.js"],
		["../../cover/js/util/authorize.js"],
		["./css/patchnote/patch-detail.css"]
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			$(".widget").widgster();
			$("#sidebar").hide();
			$(".wrap").css("margin-left", 0);
			$("#footer").load("/cover/html/template/landing-footer.html");

			initializePage();
		})
		.catch(function (error) {
			console.error("플러그인 로드 중 오류 발생");
			console.error(error);
		});
}

var globalPatchId = new URLSearchParams(window.location.search).get("id");

function initializePage() {
	if (!globalPatchId) {
		showFullScreenError("not-found");
		return;
	}
	loadPatchDetail();
	defineEvents();
}

function loadPatchDetail() {
	$.ajax({
		url: "/auth-anon/api/arms/patchnote/getNode.do",
		data: { c_id: globalPatchId },
		method: "GET",
		dataType: "json",
		success: function (patchnote) {
			if (!patchnote) {
				showFullScreenError("not-found");
				return;
			}

			renderPatchDetail(patchnote);
			validateCrudButton();
		},
		error: function (xhr, status, error) {
			showFullScreenError("default");
		}
	});
}

function renderPatchDetail(patchData) {
	const {
		c_patchnote_author_id,
		c_patchnote_title,
		c_patchnote_created,
		c_patchnote_contents,
		c_patchnote_subtitle,
		c_patchnote_thumbnail_url
	} = patchData;

	$("#patch-detail-author-id").html(c_patchnote_author_id);
	$("#patch-detail-subtitle").html(c_patchnote_subtitle);
	$("#patch-detail-title").html(c_patchnote_title);
	$("#patch-detail-created").html(c_patchnote_created);
	$("#patch-detail-content").html(c_patchnote_contents);

	const imgElement = document.createElement("img");
	imgElement.src = c_patchnote_thumbnail_url || "/cover/img/img-onerror.png";
	imgElement.style = "max-height: 200px; display: flex; margin: 0 auto; padding: 10px;";
	$("#patch-detail-thumbnail").append(imgElement);
}

function defineEvents() {
	$("#patch-edit-btn").on("click", function () {
		if (globalPatchId) window.location.href = "/cover/template.html?page=patchnoteEditor&id=" + globalPatchId;
	});

	$("#patch-delete-btn").on("click", function () {
		$("#confirmModal").modal("show");
	});

	$("#delete-confirm-yes").on("click", function () {
		$("#confirmModal").modal("hide");

		$.ajax({
			url: "/auth-user/api/arms/patchnote/removeNode.do",
			data: { c_id: globalPatchId },
			method: "DELETE",
			dataType: "json",
			success: function (response) {
				jSuccess("업데이트 노트가 성공적으로 삭제되었습니다.");
				setTimeout(function () {
					window.location.href = "/cover/template.html?page=patchnote";
				}, 1500);
			},
			error: function (xhr, status, error) {
				jError("이미 삭제되었거나 삭제 도중 오류가 발생했습니다. 새로고침 후 다시 시도해 주세요.");
			}
		});
	});
}

function validateCrudButton() {
	function valid(json) {}

	function invalid() {
		$("#patch-edit-btn").hide();
		$("#patch-delete-btn").hide();
	}

	function error() {
		showFullScreenError("default");
	}

	validateAdminRole(valid, invalid, error);
}

/**
 * 유틸 함수
 */
function showFullScreenError(errorCase, targetArgs = $(".blog-detail-container")) {
	const target = $(targetArgs);

	const getErrorHtml = (errorCode, title, message, iconClass) => `
    <div class="text-center" style="padding: 60px;">
        <i class="fa ${iconClass} fa-3x" style="color: #dc3545;"></i>
        <h3 style="margin-top: 20px;">${title}</h3>
        <p>${message}</p>
        <a href="template.html?page=patchnote" class="btn" style="margin-top: 20px; color: #313131; background: white; border: 1px solid #ddd;">업데이트 노트 홈으로</a>
    </div>
  `;

	let errorHtml;

	switch (errorCase) {
		case "not-found":
			errorHtml = getErrorHtml(
				"not-found",
				"업데이트 노트를 찾을 수 없습니다",
				"요청하신 업데이트 노트가 존재하지 않거나 삭제되었습니다.",
				"fa-exclamation-triangle"
			);
			break;
		case "not-authorized":
			errorHtml = getErrorHtml("not-authorized", "권한이 없습니다", "이 작업을 수행할 권한이 없습니다.", "fa-lock");
			break;
		default:
			errorHtml = getErrorHtml(
				"default",
				"알 수 없는 오류가 발생했습니다",
				"잠시 후 다시 시도해주세요.",
				"fa-exclamation-triangle"
			);
			break;
	}
	$(target).html(errorHtml);
}
