(function ($) {
	'use strict';

	var $target;

	var columnList = [
		{
			name: 'start_time',
			title: 'Start Time',
			data: 'start_time',
			render: function (data, type) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
			visible: true,
		},
		{
			name: 'end_time',
			title: 'End Time',
			data: 'end_time',
			visible: true,
			render: function (data, type) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
		},
		{
			name: 'duration',
			title: 'Duration',
			data: 'duration',
			render: function (data, type) {
				if (type === 'display') {
					if (isEmpty(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
		},
		{
			name: 'status',
			title: 'Status',
			data: 'status',
			visible: true,
			render: function (data, type) {
				if (type === 'display') {
					if ([null, undefined, ''].includes(data)) {
						return getEmptyCell();
					} else {
						return getDefaultCell(data);
					}
				}
				return data;
			},
			defaultContent: getEmptyCell(),
		},
	];

	$(document).on('init.schedule_history', function (event) {
		$target = $(event.target);

		$target.table({
			data: [],
			columns: columnList,
			dom: 'Blfrtip',
			buttons: [
				{
					extend: 'excel',
					charset: 'UTF-8',
					bom: true,
					title: 'HyperMig_Schedule_Config_' + getCurrentDate(),
					className: 'btn btn-default btn-sm margin-bottom',
				},
			],
			order: [],
		});
	});
})(jQuery);
