package com.arms.api.kafka.reqadd.controller;

import com.arms.api.kafka.reqadd.model.ReqAddRetryDTO;
import com.arms.api.util.response.CommonResponse;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import static com.arms.api.util.response.CommonResponse.success;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping("/auth-admin/message/queue")
public class AdminReqAddController {

    // 실패 목록 조회
    @GetMapping("/requirement/{changeReqTableName}")
    public Mono<CommonResponse.ApiResult<String>> index(
            @PathVariable String changeReqTableName
    ) {

        return Mono.just(success("OK"));

    }

    // 실패 요구사항 retry

    @PostMapping("/requirement/{changeReqTableName}")
    public Mono<CommonResponse.ApiResult<String>> retry(
            @PathVariable String changeReqTableName,
            @RequestBody ReqAddRetryDTO reqAddRetryDTO
    ) {

        return Mono.just(success("OK"));
    }

}
