/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.response;

import com.arms.api.util.errors.response.ErrorCode;
import org.springframework.http.HttpStatus;

public class CommonResponse {
    private CommonResponse() {
    }

    public static <T> ApiResult<T> success(T response) {
        return new ApiResult<T>(true, response, null);
    }

    public static <T> ApiResult<T> error(Throwable throwable, HttpStatus status) {
        return new ApiResult<Object>(false, null, new ApiError(throwable, status));
    }

    public static <T> ApiResult<T> error(String message, HttpStatus status) {
        return new ApiResult<Object>(false, null, new ApiError(message, status));
    }

    public static <T> ApiResult<T> error(ErrorCode errorCode, HttpStatus status) {
        return new ApiResult<Object>(false, null, new ApiError(errorCode, status));
    }

    public static <T> ApiResult<T> error(String message, ErrorCode errorCode, HttpStatus status) {
        return new ApiResult<Object>(false, null, new ApiError(message, errorCode, status));
    }

    public static class ApiResult<T> {
        private final boolean success;
        private final T response;
        private final ApiError error;

        private ApiResult(boolean success, T response, ApiError error) {
            this.success = success;
            this.response = response;
            this.error = error;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public ApiError getError() {
            return this.error;
        }

        public T getResponse() {
            return this.response;
        }

        public String toString() {
            return "CommonResponse.ApiResult(success=" + this.isSuccess() + ", response=" + String.valueOf(this.getResponse()) + ", error=" + String.valueOf(this.getError()) + ")";
        }
    }

    public static class ApiError {
        private final String message;
        private String errorCode;
        private final int status;

        ApiError(Throwable throwable, HttpStatus status) {
            this(throwable.getMessage(), status);
        }

        ApiError(String message, HttpStatus status) {
            this.message = message;
            this.status = status.value();
        }

        ApiError(ErrorCode errorCode, HttpStatus status) {
            this.message = errorCode.getErrorMsg(new Object[0]);
            this.errorCode = errorCode.name();
            this.status = status.value();
        }

        ApiError(String message, ErrorCode errorCode, HttpStatus status) {
            this.message = message;
            this.errorCode = errorCode.name();
            this.status = status.value();
        }

        public String getMessage() {
            return this.message;
        }

        public int getStatus() {
            return this.status;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String toString() {
            return "CommonResponse.ApiError(message=" + this.getMessage() + ", errorCode=" + this.getErrorCode() + ", status=" + this.getStatus() + ")";
        }
    }
}

