/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.mapping.service;

import com.arms.api.mapping.domain.State;
import com.arms.api.mapping.domain.StateCategory;
import com.arms.api.mapping.repository.StateCategoryRepository;
import com.arms.api.mapping.service.StateService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class StateCategoryService {
    private final StateService stateService;
    private final StateCategoryRepository stateCategoryRepository;

    public void init(List<StateCategory> stateCategoryList) {
        this.stateCategoryRepository.saveAll(stateCategoryList);
    }

    public void deleteStateCategory() {
        this.stateCategoryRepository.deleteAll();
    }

    public StateCategory getArmsStateCategoryByStateId(String stateId) {
        if (stateId == null) {
            return null;
        }
        State state = this.stateService.getArmsStateById(stateId);
        if (state == null || state.getCategoryMappingId() == null) {
            return null;
        }
        String categoryMappingId = state.getCategoryMappingId();
        StateCategory stateCategory = this.stateCategoryRepository.findById(categoryMappingId).orElseGet(() -> StateCategory.builder().build());
        return stateCategory;
    }

    public StateCategory getArmsStateCategory(String categoryId) {
        StateCategory stateCategory = this.stateCategoryRepository.findById(categoryId).orElse(null);
        return stateCategory;
    }

    public StateCategoryService(StateService stateService, StateCategoryRepository stateCategoryRepository) {
        this.stateService = stateService;
        this.stateCategoryRepository = stateCategoryRepository;
    }
}

