package com.arms.api.configserver.model;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

@Component
@ConfigurationProperties(prefix = "clients")
@Getter
@Setter
@Slf4j
public class ArmsApplicationProperties {

    private Map<String, ConfigClientUrl> urls = new HashMap<>();

    @Setter
    @Getter
    public static class ConfigClientUrl {
        private String url;
    }

    @PostConstruct
    public void logLoadedProperties() {
        if (urls.isEmpty()) {
            log.warn("❗ ArmsApplicationProperties.urls is EMPTY");
        } else {
            log.info("✅ Loaded arms.urls properties:");
            urls.forEach((key, value) -> log.info(" - {} => {}", key, value.getUrl()));
        }
    }
}
