package com.arms.api.util.errors.response;


import com.arms.api.util.response.CommonResponse.ApiResult;
import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import static com.arms.api.util.response.CommonResponse.error;

@ControllerAdvice
@RequiredArgsConstructor
public class ErrorControllerAdvice {

  private final SlackNotificationService slackNotificationService;


  private  <E> ResponseEntity<ApiResult<E>> newResponse(String message, ErrorCode errorCode, HttpStatus status) {
    HttpHeaders headers = getHttpHeaders();
    return new ResponseEntity<>(error(message, errorCode, status), headers, status);
  }

  private  <E> ResponseEntity<ApiResult<E>> newResponse(ErrorCode errorCode, HttpStatus status) {
    HttpHeaders headers = getHttpHeaders();
    return new ResponseEntity<>(error(errorCode, status), headers, status);
  }

  private  HttpHeaders getHttpHeaders() {
    HttpHeaders headers = new HttpHeaders();
    headers.add("Content-Type", "application/json");
    return headers;
  }

  @ExceptionHandler(IllegalArgumentException.class)
  public <E> ResponseEntity<ApiResult<E>> handleArgumentException(IllegalArgumentException e) {
    return newResponse(e.getMessage(),ErrorCode.COMMON_INVALID_PARAMETER,HttpStatus.BAD_REQUEST);
  }

  @ExceptionHandler(Exception.class)
  public <E> ResponseEntity<ApiResult<E>> handleAllException(Exception e) {
    slackNotificationService.sendMessageToChannel(SlackProperty.Channel.globalconfig, e);
    return newResponse(e.getMessage(), ErrorCode.COMMON_SYSTEM_ERROR, HttpStatus.INTERNAL_SERVER_ERROR);
  }

}
