package com.arms.api.systeminfo.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

import java.util.Date;

import org.springframework.util.ObjectUtils;

@Builder
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
@JsonIgnoreProperties(ignoreUnknown = true)
public class SystemInfoVO {

    @JsonProperty("system-info")
    private SystemInfoDetails systemInfoDetails;

    public boolean isExistLicenseNumber(){
        if(systemInfoDetails!=null){
            LicenseInfo licenseInformation = systemInfoDetails.getLicenseInformation();
            if(licenseInformation!=null){
                return !ObjectUtils.isEmpty(licenseInformation.getLicense_number());
            }
        }
        return false;
    }

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    @ToString
    public static class SystemInfoDetails {
        @JsonProperty("general-settings")
        private GeneralSettings generalSettings;
        private Internalization internalization;
        @JsonProperty("server-config")
        private ServerConfig serverConfig;
        @JsonProperty("license-info")
        private LicenseInfo licenseInformation;
    }

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    @ToString
    public static class GeneralSettings {
        @JsonProperty("product-name")
        private String product_name;
        @JsonProperty("product-version")
        private String product_version;
        @JsonProperty("base-url")
        private String base_url;
        @JsonProperty("service-status")
        private String service_status;
    }

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    @ToString
    public static class Internalization {
        @JsonProperty("default-language")
        private String default_language;
        @JsonProperty("time-zone")
        private String time_zone;
    }

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    @ToString
    public static class ServerConfig {
        @JsonProperty("connection-timeout")
        private Long connection_timeout;
        @JsonProperty("socket-timeout")
        private Long socket_timeout;
    }

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    @JsonIgnoreProperties(ignoreUnknown = true)
    @ToString
    public static class LicenseInfo {
        private Long org_link;
        @JsonProperty("org-name")
        private String org_name;
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
        @JsonProperty("purchase-date")
        private Date purchase_date;
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
        @JsonProperty("expiration-date")
        private Date expiration_date;
        @JsonProperty("license-type")
        private String license_type;
        @JsonProperty("license-update")
        private String license_update;
        @JsonProperty("license-number")
        private String license_number;
        @JsonProperty("server-id")
        private String server_id;
        @JsonProperty("host-limit")
        private Long host_limit;
        private String note;
    }
}
