/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.schedule.util;

import com.arms.api.schedule.model.dto.ScheduleInfoDTO;
import com.arms.api.schedule.model.vo.ScheduleInfoVO;
import com.arms.api.schedule.util.ScheduleFileReader;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleFileReader {
    private static final Logger log = LoggerFactory.getLogger(ScheduleFileReader.class);

    public static List<ScheduleInfoVO> readScheduleYmlFileAndParseToVO(String fileUrl, String username, String password) throws Exception {
        List scheduleInfoList = null;
        log.info("[ ScheduleFileReader :: readScheduleYmlFileAndParseToVO ] :: fileUrl => {}", (Object)fileUrl);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(fileUrl).openConnection();
            String auth = username + ":" + password;
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                    ScheduleListWrapper wrapper = (ScheduleListWrapper)mapper.readValue((Reader)reader, ScheduleListWrapper.class);
                    scheduleInfoList = wrapper.getSchedule();
                }
                catch (Exception e) {
                    log.error("YAML \ud30c\uc2f1 \uc624\ub958: {}", (Object)e.getMessage(), (Object)e);
                }
            } else {
                log.error("HTTP \uc694\uccad \uc2e4\ud328. \uc751\ub2f5 \ucf54\ub4dc: {}", (Object)responseCode);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            log.error("URL \uc5f0\uacb0 \uc624\ub958: {}", (Object)e.getMessage(), (Object)e);
        }
        return scheduleInfoList;
    }

    public static String convertScheduleListToYaml(List<ScheduleInfoDTO> scheduleList) {
        StringBuilder yamlContent = new StringBuilder("schedule:\n");
        for (ScheduleInfoDTO scheduleInfoDTO : scheduleList) {
            yamlContent.append("  - name: \"").append(scheduleInfoDTO.getName()).append("\"\n").append("    cron: \"").append(scheduleInfoDTO.getCron()).append("\"\n").append("    notes: \"").append(scheduleInfoDTO.getNotes()).append("\"\n").append("    enabled: ").append(scheduleInfoDTO.getEnabled()).append("\n");
        }
        return yamlContent.toString();
    }
}

