/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.gcframework.parser;

import com.arms.egovframework.javaservice.gcframework.model.AbstractContentVO;
import com.arms.egovframework.javaservice.gcframework.parser.AbstractContentParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class JsonContentParser
extends AbstractContentParser<AbstractContentVO> {
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public String getHandledType() {
        return "json";
    }

    protected AbstractContentVO doParse(String decodedContent, Class<AbstractContentVO> targetVoType) {
        try {
            return (AbstractContentVO)this.jsonMapper.readValue(decodedContent, targetVoType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON content", e);
        }
    }

    protected String doSerialize(AbstractContentVO targetVO) {
        try {
            return this.jsonMapper.writeValueAsString((Object)targetVO);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize to JSON content", e);
        }
    }
}

