/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.errors;

import com.arms.api.util.errors.ErrorCode;
import com.arms.api.util.response.CommonResponse;
import com.arms.api.util.slack.SlackNotificationService;
import com.arms.api.util.slack.SlackProperty;
import io.swagger.v3.oas.annotations.Hidden;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Hidden
@RestControllerAdvice(annotations={RestController.class})
public class ErrorControllerAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorControllerAdvice.class);
    private final SlackNotificationService slackNotificationService;

    private ResponseEntity<CommonResponse.ApiResult<?>> newResponse(String message, HttpStatus status) {
        HttpHeaders headers = this.getHttpHeaders();
        return new ResponseEntity(CommonResponse.error(message, status), (MultiValueMap)headers, (HttpStatusCode)status);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        return headers;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> onException(Exception e) {
        this.slackNotificationService.sendMessageToChannel(SlackProperty.Channel.engine, e);
        return this.newResponse(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MissingPathVariableException.class})
    public ResponseEntity<?> \ucee4\ub125\ud2b8\uc544\uc774\ub514_\uc624\ub958\uccb4\ud06c(MissingPathVariableException \uc5d0\ub7ec) {
        String variableName = \uc5d0\ub7ec.getVariableName();
        log.error("\ucee4\ub125\ud2b8 \uc544\uc774\ub514:", (Throwable)\uc5d0\ub7ec);
        if ("connectId".equals(variableName)) {
            return this.newResponse(ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]), HttpStatus.BAD_REQUEST);
        }
        return this.newResponse(ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ResponseEntity<?> \uc804\uc1a1\ub370\uc774\ud130_\uc720\ud6a8\uc131\uccb4\ud06c(MethodArgumentNotValidException \uc5d0\ub7ec) {
        log.error("\ud638\ucd9c \ub41c '\uac1d\uccb4' \ud639\uc740 '\ud30c\ub77c\ubbf8\ud130' \ub370\uc774\ud130 \uac12\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4 :", (Throwable)\uc5d0\ub7ec);
        return this.newResponse(ErrorCode.REQUESTED_DATA_INVALID.getErrorMsg(new Object[0]), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    protected ResponseEntity<?> HttpMessageNotReadableException(HttpMessageNotReadableException \uc5d0\ub7ec) {
        log.error("\uc694\uccad \ubcf8\ubb38\uc774 \uc5c6\uac70\ub098 JSON \ud615\uc2dd\uc774 \uc544\ub2d9\ub2c8\ub2e4. ", (Throwable)\uc5d0\ub7ec);
        return this.newResponse(ErrorCode.REQUEST_BODY_ERROR_CHECK.getErrorMsg(new Object[0]), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<?> handleIllegalArgumentException(IllegalArgumentException \uc5d0\ub7ec) {
        log.error(\uc5d0\ub7ec.getMessage());
        return this.newResponse(\uc5d0\ub7ec.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @Generated
    public ErrorControllerAdvice(SlackNotificationService slackNotificationService) {
        this.slackNotificationService = slackNotificationService;
    }
}

