/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.alm;

import com.arms.api.util.errors.ErrorLogUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.RedmineManagerFactory;
import com.taskadapter.redmineapi.bean.User;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class RedmineUtil {
    public RedmineManager createRedmineOnPremiseCommunicator(String uri, String apiKey) {
        return RedmineManagerFactory.createWithApiKey((String)uri, (String)apiKey);
    }

    public static WebClient createRedmineWebClientCommunicator(String uri, String apiToken) {
        return WebClient.builder().baseUrl(uri).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("X-Redmine-API-Key", new String[]{apiToken}).build();
    }

    public String checkServerInfoPath(String serverInfoPath) {
        return serverInfoPath.endsWith("/") ? serverInfoPath.substring(0, serverInfoPath.length() - 1) : serverInfoPath;
    }

    public User getUserInfo(RedmineManager redmineManager, String userId) {
        User userInfo = null;
        try {
            userInfo = redmineManager.getUserManager().getUserById(Integer.valueOf(userId));
        }
        catch (RedmineException e) {
            ErrorLogUtil.exceptionLogging((Exception)((Object)e), this.getClass().getName(), userId + " \uc0ac\uc6a9\uc790\uc815\ubcf4 \uc870\ud68c \uc624\ub958");
        }
        return userInfo;
    }

    public <T> Mono<T> get(WebClient webClient, String uri, Class<T> responseType) {
        return webClient.get().uri(uri, new Object[0]).retrieve().bodyToMono(responseType);
    }

    public Optional<String> toJson(Object object) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        try {
            String json = gson.toJson(object);
            return Optional.of(json);
        }
        catch (Exception e) {
            ErrorLogUtil.exceptionLogging(e, this.getClass().getName(), "JSON \ubcc0\ud658 \uc2e4\ud328");
            return Optional.empty();
        }
    }
}

