/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.project.service;

import com.arms.api.project.strategy.CloudJiraProjectStrategy;
import com.arms.api.project.strategy.OnpremiseJiraProjectStrategy;
import com.arms.api.project.strategy.OnpremiseRedmineProjectStrategy;
import com.arms.api.project.strategy.ProjectStrategy;
import com.arms.api.project.strategy.ProjectStrategyImpl;
import com.arms.api.project.vo.ProjectVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectService.class);
    private final ServerInfoService serverInfoService;
    private final CloudJiraProjectStrategy cloudJiraProjectStrategy;
    private final OnpremiseJiraProjectStrategy onpremiseJiraProjectStrategy;
    private final OnpremiseRedmineProjectStrategy onpremiseRedmineProjectStrategy;

    private ProjectStrategyImpl settingProjectStrategy(ServerInfo serverInfo) {
        ProjectStrategy projectStrategy;
        if (serverInfo == null || StringUtils.isEmpty((CharSequence)serverInfo.getType())) {
            String errorMessage = "\ud504\ub85c\uc81d\ud2b8 \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 Null " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]);
            log.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        ServerType serverType = ServerType.typeValueOf(serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            projectStrategy = this.cloudJiraProjectStrategy;
        } else if (serverType == ServerType.ON_PREMISS) {
            projectStrategy = this.onpremiseJiraProjectStrategy;
        } else if (serverType == ServerType.REDMINE_ON_PREMISS) {
            projectStrategy = this.onpremiseRedmineProjectStrategy;
        } else {
            throw new IllegalArgumentException("\ud504\ub85c\uc81d\ud2b8 \uc804\ub7b5 \ud655\uc778 Error: \ud5c8\uc6a9\ud558\uc9c0 \uc54a\ub294 serverInfo_\uc720\ud615\uc785\ub2c8\ub2e4. :: " + String.valueOf((Object)serverType) + " :: " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        ProjectStrategyImpl projectStrategyImpl = new ProjectStrategyImpl();
        projectStrategyImpl.registerProjectStrategy(projectStrategy);
        return projectStrategyImpl;
    }

    public ProjectVO getProject(String connectId, String projectKeyOrId) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(connectId);
        ProjectStrategyImpl projectStrategy = this.settingProjectStrategy(serverInfo);
        return projectStrategy.getProject(serverInfo, projectKeyOrId);
    }

    public List<ProjectVO> getProjectList(String connectId) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(connectId);
        ProjectStrategyImpl projectStrategy = this.settingProjectStrategy(serverInfo);
        return projectStrategy.getProjectList(serverInfo);
    }

    @Generated
    public ProjectService(ServerInfoService serverInfoService, CloudJiraProjectStrategy cloudJiraProjectStrategy, OnpremiseJiraProjectStrategy onpremiseJiraProjectStrategy, OnpremiseRedmineProjectStrategy onpremiseRedmineProjectStrategy) {
        this.serverInfoService = serverInfoService;
        this.cloudJiraProjectStrategy = cloudJiraProjectStrategy;
        this.onpremiseJiraProjectStrategy = onpremiseJiraProjectStrategy;
        this.onpremiseRedmineProjectStrategy = onpremiseRedmineProjectStrategy;
    }
}

