/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.holidayadmin.service;

import com.arms.api.holidayadmin.model.dto.HolidayDTO;
import com.arms.api.holidayadmin.model.entity.HolidayEntity;
import com.arms.api.holidayadmin.model.vo.HolidayVO;
import com.arms.api.holidayadmin.service.HolidayService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class HolidayServiceImpl
implements HolidayService {
    private final EsCommonRepositoryWrapper<HolidayEntity> esCommonRepositoryWrapper;

    @Override
    public String postMessage(HolidayDTO holidayDTO) {
        HolidayEntity save = this.esCommonRepositoryWrapper.save(holidayDTO.toBbsEntityWithCreate());
        return save.getId();
    }

    @Override
    public String updateBbsAndNewGroupId(HolidayDTO holidayDTO) {
        String bbsId = this.updateBbsAndGetId(holidayDTO);
        HolidayEntity holidayEntity = this.esCommonRepositoryWrapper.findDocById(bbsId);
        HolidayDTO sourceHolidayDTO = holidayDTO.toBbsDtoWithBoardTypeAndGroupId(holidayEntity);
        HolidayVO holidayVO = this.bbsList(sourceHolidayDTO);
        holidayVO.getBbsEntities().forEach(this.esCommonRepositoryWrapper::save);
        return holidayDTO.getId();
    }

    @Override
    public String updateBbsAndGetId(HolidayDTO holidayDTO) {
        HolidayEntity findHolidayEntity = this.esCommonRepositoryWrapper.findDocById(holidayDTO.getId());
        if (findHolidayEntity == null) {
            throw new IllegalArgumentException("\uc0ad\uc81c\ub41c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.");
        }
        findHolidayEntity.updateHolidayEntity(holidayDTO.toBbsEntityWithUpdate());
        HolidayEntity save = this.esCommonRepositoryWrapper.save(findHolidayEntity);
        return save.getId();
    }

    @Override
    public String deleteBbsAndGetId(String deleteId) {
        HolidayEntity holidayEntity = this.esCommonRepositoryWrapper.findDocById(deleteId);
        if (holidayEntity == null) {
            throw new IllegalArgumentException("\uac8c\uc2dc\uae00\uc774 \uc0ad\uc81c \ub418\uc5b4\uc11c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4..");
        }
        this.esCommonRepositoryWrapper.deleteById(holidayEntity.getId());
        return deleteId;
    }

    @Override
    public HolidayVO bbsList(HolidayDTO holidayDTO) {
        DocumentResultWrapper<HolidayEntity> docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(SimpleQuery.search(holidayDTO).orderBy(SortDTO.builder().field("group_id").sortType("desc").build(), SortDTO.builder().field("path").sortType("asc").build()));
        List<HolidayEntity> docs = docsBySearchAfter.toDocs();
        return HolidayVO.builder().bbsEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    @Generated
    public HolidayServiceImpl(EsCommonRepositoryWrapper<HolidayEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

