/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.holidayadmin.controller;

import com.arms.api.holidayadmin.model.dto.HolidayDTO;
import com.arms.api.holidayadmin.model.vo.HolidayVO;
import com.arms.api.holidayadmin.service.HolidayService;
import com.arms.api.util.response.CommonResponse;
import feign.Param;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/holiday"})
public class HolidayController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HolidayController.class);
    private final HolidayService bbsService;

    @GetMapping(value={"/board-list/only-post-list"})
    public ResponseEntity<CommonResponse.ApiResult<HolidayVO>> postList(@Param(value="baseDTO") HolidayDTO holidayDTO) {
        log.info("BbsController :: postList");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.bbsList(holidayDTO)));
    }

    @GetMapping(value={"/board-list"})
    public ResponseEntity<CommonResponse.ApiResult<HolidayVO>> boardList(@Param(value="baseDTO") HolidayDTO holidayDTO) {
        log.info("BbsController :: boardList");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.bbsList(holidayDTO)));
    }

    @PostMapping(value={"/post-message"})
    public ResponseEntity<CommonResponse.ApiResult<String>> savePostMessage(@RequestBody HolidayDTO holidayDTO) {
        log.info("BbsController :: savePostMessage");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.postMessage(holidayDTO)));
    }

    @PutMapping(value={"/update-id/{updateId}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> update(@PathVariable(name="updateId") String updateId, @RequestBody HolidayDTO holidayDTO) {
        log.info("BbsController :: update");
        holidayDTO.setId(updateId);
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.updateBbsAndGetId(holidayDTO)));
    }

    @DeleteMapping(value={"/delete-id/{deleteId}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteById(@PathVariable(name="deleteId") String deleteId) {
        log.info("BbsController :: deleteById");
        return ResponseEntity.ok(CommonResponse.success(this.bbsService.deleteBbsAndGetId(deleteId)));
    }

    @Generated
    public HolidayController(HolidayService bbsService) {
        this.bbsService = bbsService;
    }
}

