
# Light Blue Dashboard - free and open source admin dashboard template
Awesome transparent design with responsive layout built with Bootstrap.

[View Demo](https://flatlogic.github.io/light-blue-dashboard/) | [Download](https://github.com/flatlogic/light-blue-dashboard/archive/master.zip) | [Full version](https://flatlogic.com/admin-dashboards/light-blue-html5) | [More templates](https://flatlogic.com/admin-dashboards) | [Support forum](https://flatlogic.com/forum)



[![header_illustration_fb](https://user-images.githubusercontent.com/24964748/47848527-a75aee80-dddf-11e8-82ae-b5472e20df7f.png)](https://flatlogic.github.io/light-blue-dashboard/)

This repository contains a limited free version of [Light Blue](https://flatlogic.com/admin-dashboards/light-blue-html5/demo). [Full bootstrap 4](https://flatlogic.com/admin-dashboards/light-blue-html5/demo), [React](https://flatlogic.com/admin-dashboards/light-blue-react/demo) and [Angular](https://flatlogic.com/admin-dashboards/light-blue-angular/demo) versions are also available via our website.

## Features

Using this template you will be able to leverage lots of built-in components and thus focus on building features that set you apart from competitors rather than bulding everything from scratch. Lite version of a Light Blue Dashboard includes following features and pages:
* Bootstrap & SCSS
* Unique transparent design
* Responsive layout
* Styled Bootstrap components like buttons, modals, etc
* Dashboard sample
* Typography
* Tables
* Notifications
* Base charts
* Icons
* Maps

All other features like themining, login, additional pages, etc are available in [full version](https://flatlogic.com/admin-dashboards/light-blue-html5/demo).

[![full-version](https://user-images.githubusercontent.com/24964748/47848874-c4dc8800-dde0-11e8-93e7-a78c1e098207.png)](https://flatlogic.com/admin-dashboards/light-blue-html5/demo)

## Quick Start

#### 1. Get the latest version

You can start by cloning the latest version of Light Blue Dashboard on your local machine by running:

```shell
$ git clone -o light-blue-dashboard -b master --single-branch \
      https://github.com/flatlogic/light-blue-dashboard.git MyApp
$ cd MyApp
```

#### 2. Run `npm install && bower install`

This will install both run-time project dependencies and developer tools listed
in [package.json](../package.json) file. We are moving all dependencies to npm, so there will be no bower dependencies soon.

#### 3. Run `npm install -g grunt`

This commant will install grunt task runner globally.

#### 4. Run `grunt`

This command will build the app from the source files (`/src`) into the output
`/dist` folder. Then open `dist/index.html` in your browser.

Now you can open your web app in a browser, on mobile devices and start
hacking. The page must be served from a web server, e.g. apache, nginx, WebStorm built-in web server, etc., otherwise some features may not work properly.

#### 5. Run `grunt watch`
This command will watch for changes in `/src` and recompile handlebars' templates & scss styles on the fly into html & css accordingly.


## Integration & Customization
[![integration sample](https://user-images.githubusercontent.com/24964748/47849384-7334fd00-dde2-11e8-8329-dc4b9d8927d0.png)](https://flatlogic.com/services/admin-template-integration)

Light Blue Dashboard is a part of [admin dashboard solution](https://flatlogic.com/services/admin-template-integration) provided by Flatlogic. We can integrate admin dashboards with such systems as your accounting software, customer relationship management (CRM) system, email management, marketing automation, website analytics program, etc. With this dashboard, the owner of the website (platform) can easily track orders and their success rate, track social metrics such as the most popular referring social media sites and their appropriate URLs, monitor sales states and periods of growth to better understand what makes users tick. [Contact us](https://flatlogic.com/contact) to learn more.

## Support
For any additional information please go to our [**support forum**](https://flatlogic.com/forum) and raise your questions or feedback provide there. We highly appreciate your participation!

## How can I support developers?
- Star our GitHub repo :star:
- [Tweet about it](https://twitter.com/intent/tweet?text=Amazing%20dashboard%20built%20with%20NodeJS,%20React%20and%20Bootstrap!&url=https://github.com/flatlogic/sing-app&via=flatlogic).
- Create pull requests, submit bugs, suggest new features or documentation updates :wrench:
- Follow [@flatlogic on Twitter](https://twitter.com/flatlogic).
- Subscribe to Flatlogic newsletter at [flatlogic.com](https://flatlogic.com/)
- Like our page on [Facebook](https://www.facebook.com/flatlogic/) :thumbsup:

## Premium themes
Looking for premium themes and templates? Check out our other template at [flatlogic.com](https://flatlogic.com/admin-dashboards).

## License

Light Blue Dashboard is [MIT](https://github.com/flatlogic/light-blue-dashboard/blob/master/LICENSE.txt)-licensed.
